/* Copyright Barbara Liskov, MIT 1996 */

#ifndef _COMMIT_H
#define _COMMIT_H

#ifdef __cplusplus
extern "C" {
#endif

typedef enum {
    COMMITTED,
    STALE_READ_ABORT,
    FAILED_ABORT,
    UNEXPECTED_MSG_ABORT
} commit_result;

extern commit_result commit_trans (); 
/* effects commits the current transaction. Starts the next transaction
	   and returns the result of the commit.
*/

extern void abort_trans();
/* effects aborts the transaction unconditionally (cleans up the state of
           this transaction and sets it up for the next one */

#ifdef __cplusplus
}
#endif

#endif /* _COMMIT_H */
