/* Copyright Barbara Liskov, MIT 1996 */

#ifndef _FORCE_H
#define _FORCE_H

#include "common/th_assert.h"
#include "types/type.h"
#include "types/class.h"
#include "runtime/obj_class.h"

/* Sometimes, force is required, but try using diplomacy first. */

/* FORCE: Cast the value VAL to the C type CTYPE, which is represented
   by the Theta type object TYPEOBJ. If TYPEOBJ matches CTYPE properly,
   it is a checked runtime error to pass a value that is not representable
   as CTYPE. Passing a TYPEOBJ that does not correspond will have
   unpredictable results.
*/

/*
   XXX These macros don't really do enough if the destination type
   is not compatible with the source type. A call to hdr_offset is
   really needed instead.
*/

#define FORCE(VAL, CTYPE, TYPEOBJ) \
	(th_assert(isSubtype(class_as_type(get_obj_class((obj)VAL)),	\
			     (type)TYPEOBJ),				\
		   "FORCE failed"),					\
	 (CTYPE)VAL)							\



/* CAST: Cast the value VAL to the C type CTYPE, which is represented
   by the Theta type object TYPEOBJ, returning NULL if VAL is not
   representable as a CTYPE.

   Passing a TYPEOBJ that does not correspond to CTYPE will have
   unpredictable results.
*/

#define CAST(VAL, CTYPE, TYPEOBJ) 					      \
	(isSubtype(class_as_type(get_obj_class((obj)VAL)), 		      \
		   (type)TYPEOBJ) ? (CTYPE)VAL : (CTYPE) 0)	

#endif /* _FORCE_H */
