/* Copyright Barbara Liskov, MIT 1996 */

/* Assembly coded full-surrogate methods to avoid function call. */

#include "config/vdefs/ASM_SURR_METHODS.h"

#if ASM_SURR_METHODS

#include <regdef.h>
#define FOFFSET 8	/* the offset of foffset in dv */
#define LONGWORDSIZE 8 
#define DV_S_SIZE 40    /* the offset of the 0th method in dv */

#define ASM_FULL_SURR_METHOD(N)						\
	.globl full_surr_method_##N;					\
	.ent full_surr_method_##N;					\
full_surr_method_##N:							\
	ldq t1, 0(a0);							\
	ldl t2, FOFFSET(t1);						\
	addq a0, t2, t3;						\
	ldq a0, 0(t3);							\
	ldq t1, 0(a0);							\
	ldq pv, DV_S_SIZE+N*LONGWORDSIZE(t1);				\
	jmp (pv);							\
	.end full_surr_method_##N

#define ASM_METHODS_FILE
#include "special_methods.h"

#endif /* ASM_SURR_METHODS */
