/* Copyright Barbara Liskov, MIT 1996 */

#ifndef _PVAL_H
#define _PVAL_H

#include "runtime/obj.h"

typedef obj pval;
/*
   A "pval" is the type used as an argument of variable type to
   parameterized functions. It must be as large as an "fevalue".
*/

#define UNPV(t,pval) ((t)(pval))
/*
   Convert a "pval" into a value of type "t". The type "t" must
   be the type on which the "pval"'s type parameter has been
   parameterized.
*/

#define PV(x) ((pval)(x))
/*
   Convert a value into a "pval". The declared type of "x" must be
   the type on which the "pval"'s type parameter has been
   parameterized.
*/

#endif /* _PVAL_H */
