/* Copyright Barbara Liskov, MIT 1996 */

#ifndef _STAMPS_H
#define _STAMPS_H

#include "common/bits.h"

/* These are the primitive macros for manipulating the 
   read and write stamps of objects.  If you are writing the code
   to implement a class, you should look at FIXUPREAD and FIXUPWRITE
   in obj_class.h instead.  */

#define READ_MARK_MASK 0x10L

#define USED_MARK_MASK 0x1L

#define WRITE_MARK_MASK 0x2L

#define COPIED_MARK_MASK 0x8L
/* Whether GC has copied an object in fromspace or not */

#define TRAVERSE_MARK_MASK 0x20L

/* Read mark and used mark are in same word, so must be different bits */
#if (READ_MARK_MASK == USED_MARK_MASK)
#error Read mark and used mark trying to use same bit
#endif

/* these macros are for use only in implementing FIXUPREAD and FIXUPWRITE.
   Class code should call FIXUPREAD and FIXUPWRITE, not these. */

#define MARK_READ_PRIM(x) ((x) | READ_MARK_MASK)
#define UNMARK_READ_PRIM(x) ((x) & ~READ_MARK_MASK)
#define IS_READ_PRIM(x) ((x) & READ_MARK_MASK)

#define MARK_WRITE_PRIM(x) ((x) | WRITE_MARK_MASK)
#define UNMARK_WRITE_PRIM(x) ((x) & ~WRITE_MARK_MASK)
#define IS_WRITE_PRIM(x) ((x) & WRITE_MARK_MASK)

/* These macros are for the use of the LRU/MRU shrinking mechanism only.
   No class code should ever use these. */

#define MARK_USED_PRIM(x) ((x) | USED_MARK_MASK)
#define UNMARK_USED_PRIM(x) ((x) & ~USED_MARK_MASK)
#define IS_USED_PRIM(x) ((x) & USED_MARK_MASK)

#define MARK_COPIED_PRIM(x) ((x) | COPIED_MARK_MASK)
#define UNMARK_COPIED_PRIM(x) ((x) & ~COPIED_MARK_MASK)
#define IS_COPIED_PRIM(x) ((x) & COPIED_MARK_MASK)

#define MARK_TRAVERSE_PRIM(x) ((x) | TRAVERSE_MARK_MASK)
#define UNMARK_TRAVERSE_PRIM(x) ((x) & ~TRAVERSE_MARK_MASK)
#define IS_TRAVERSE_PRIM(x) ((x) & TRAVERSE_MARK_MASK)

#endif /* _STAMPS_H */
