/* Copyright Barbara Liskov, MIT 1996 */

#include "common/th_assert.h"
#include "runtime/surr.h"
#include "runtime/disphdr.h"
#include "cache/local_cacheval.h"
#include <assert.h>

#define IDENT(a) a

void surr_fill (surr s, obj x) {
  objtype t;
  int dhsize;
  assert(IDENT(IS_SURR(s) && !IS_FULL_SURR(s))); 
  t = (*s)->t;
  dhsize = hdr_size(t);
  th_assert(dhsize > 0, "Nonsense size for dispatch header");
  if (dhsize == 1) oac(s)->methods = *t->full_surr_DH;
  else memcpy(s, t->full_surr_DH, dhsize * sizeof(DV));
  *SURR_FORWARD(s) = x; 
}

Xref get_pointer_xref(obj x) {
  local_cacheval c;
  th_assert(IS_MARKED_POINTER(x), "Tried to fetch using an unmarked pointer");
  c.vm_addr = UNMARK_POINTER(x);
  return c.xref;
}

void set_pointer_xref(void *x_, Xref val) {
  local_cacheval *x;
  x = (local_cacheval *)x_;
  th_assert(!IS_MARKED_POINTER(x->vm_addr), 
	    "Tried to overwrite an xref pointer");
  x->xref = val;
  x->vm_addr = MARK_POINTER(x->vm_addr);
}

bool is_marked_pointer(obj x) {return IS_MARKED_POINTER(x);}
obj mark_pointer(obj x) {return MARK_POINTER(x);}
obj unmark_pointer(obj x) {return UNMARK_POINTER(x);}

