/* Copyright Barbara Liskov, MIT 1996 */

#ifndef _SURR_DEF_H
#define _SURR_DEF_H

/* Having this definition outside surr.h avoids a cyclic dependency 
   between surr.h and disphdr.h */

#include "runtime/obj.h"

typedef obj surr;

/* 
   EDGE_MARKING determines the technique used to check whether
   an object is present in the cache or not.  If EDGE_MARKING is
   TRUE, then an obj may have a distinguished bit set in the pointer,
   and that bit is checked before using the pointer.  Otherwise,
   an obj is always a valid pointer, and absent objects are implemented
   by surrogates.
*/

#include "config/vdefs/EDGE_MARKING.h"

#endif
