/* Copyright Barbara Liskov, MIT 1996 */

#ifndef _SURR_XREF_H
#define _SURR_XREF_H

#ifdef __cplusplus
extern "C" {
#endif

/* Next word after given address, assuming correct alignment */
#define NEXT_WORD(x) ((Xref *)(((obj)(x)) + 1))

/* The (Xref *) of an empty surrogate.  Requires IS_SURR(x) */
#if EDGE_MARKING
#define SURR_XREF(x) \
   (th_fail("Tried to use SURR_XREF in system without surrogates"), (Xref *)0)
#else
#define SURR_XREF(x) \
   NEXT_WORD((char *)(x) + ((*(x))->offset))
#endif

/* The Xref contained in a marked pointer.  Requires IS_MARKED_POINTER(x) */
/* XXX This code needs to be extended to do a hash-table lookup on 
       any machine too narrow to put an xref into a pointer. */
#if EDGE_MARKING
#ifdef __alpha


Xref get_pointer_xref(obj x);

void set_pointer_xref(void *x, Xref val);  /* actually must be cacheval *x */

#else  /* EDGE_MARKING & (! __alpha) */
#error edge marking not implemented for narrow machines yet
#endif /* __alpha */

#else  /* ! EDGE_MARKING */

#define POINTER_XREF(x) \
   (th_fail("Tried to use POINTER_XREF in system with surrogates"), (Xref *)0)
#define SET_POINTER_XREF(x) \
   th_fail("Tried to use SET_POINTER_XREF in system with surrogates");

#endif /* EDGE_MARKING */

#ifdef __cplusplus
}
#endif

#endif /* _SURR_XREF_H */
