/* Copyright Barbara Liskov, MIT 1996 */

#ifndef _UNSWIZ_H
#define _UNSWIZ_H

#include "common/modset.h"
#include "common/or_num.h"
#include "runtime/transinfo.h"
#include "runtime/obj.h"

class Transaction;
class cores;

extern void unswizzle_object(TransactionSet* tset, Modset* mset, 
			     Obj_Handle handle,
			     OR_num or_num, core c, cores* nobjs,
			     NewObjTable *table);
// requires	"mset" is a MOS or NOS of one of the transactions in "tset".
//		"handle" names an allocated object in "mset" that is big
//		enough to hold "c".
//              "or_num" is OR number where object named by "handle" resides
//              (or will reside after this transaction).
// effects	Translates the contents of "c" into the object named by
//		handle.  If any newly persistent objects are encountered,
//		those objects are recursively unswizzled into the NOS
//              of a transaction in tset, and appended to "nobjs" in the 
//              order of their insertion into an NOS.
//              (core, new object name) pairs for new objects are inserted
//              into table.

bool get_xref(obj o, Xref& x);
    // requires o to be a virtual memory pointer or xref
    // effects If "o" is persistent, store its xref in x and
    //         return TRUE, else return FALSE.


#endif /* _UNSWIZ_H */
