#include <assert.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/wait.h>
#include "client/shm_connect.h"

#include "config/vdefs/USE_SIGS.h"
#include "config/vdefs/NDEBUG.h"

extern "C" unsigned usleep(unsigned);
extern "C" int shmget(key_t, u_int, u_int);

ShmServer *server;
int shmid;

void *get_shared_mem(size_t bytes)
{
    shmid = shmget(IPC_PRIVATE, bytes, IPC_CREAT | 0777);
    if (shmid < 0) {
	fprintf(stderr, "Couldn't get shared memory\n");
	exit(EXIT_FAILURE);
    }
	
    void *ret = shmat(shmid, 0, 0);
    if (-1 == (ptrdiff_t)ret) {
	fprintf(stderr, "Couldn't attach shared memory\n");
	exit(EXIT_FAILURE);
    }
    return ret;
}

void destroy_shared_mem(void *addr, int shmid)
{
    shmdt((char *)addr);
    shmctl(shmid, IPC_RMID, 0);
    fprintf(stderr, "Destroyed shared memory\n");
}

void catch_int(int dummy)
{
    destroy_shared_mem(server, shmid);
    exit(EXIT_FAILURE);
}
		     
void *operator new(size_t s, void *addr)
{
    return addr;
}


void main(int argc, char **argv)
{
    int bufsize = SHMBUFSIZ - 1;
    if (argc == 1) {
	fprintf(stderr, "Usage: %s <iters> [sleeplen [bufsize]]\n", argv[0]);
	exit(EXIT_FAILURE);
    }
    if (argc > 3) bufsize = atoi(argv[3]);
    server = new (get_shared_mem(sizeof(ShmServer))) ShmServer(bufsize);
    int i;
    int n = atoi(argv[1]);
    if (argc > 2) {
#if !USE_SIGS && !USE_MSEM && !USE_SCHED
	sleeplen = atoi(argv[2]);
#endif
    }
    if (fork() != 0) {
	signal(SIGINT, catch_int);

	ShmClient *client = server->asClient();
	int j, i2;
	assert(client->looksOk());
	client->beClient();
	for (j = 0; j<n; j++)  {
	    i2 = client->get();
#ifndef NDEBUG
	    if (i2 != j) {
		fprintf(stderr,
		    "Synchronization error! (expected %d, saw %d)\n",
			j, i2);
		server->dump("buffer 2", 2, TRUE);
	    }
#endif
	    assert(i2 == j);
	}
	client->wakeupServer();
	fprintf(stderr, "Received all values\n");

    } else {

	server->beServer();
	for (i = 0; i<n; i++)  {
	    server->put(i);
	}
	server->wakeupClient();

	shmdt((char *)server);
	exit(0);
    }
    int *dummy;
    (void)wait(dummy);
    destroy_shared_mem(server, shmid);
}
