#include <assert.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/wait.h>
extern "C" {
#include <sched.h>
}

#include "config/vdefs/NDEBUG.h"

int shmid;
long *ptr;

#define RANDSIZE(j) (MAXBUF/(1 + (((j) ^ 0x5555) & (MAXBUF - 1))))

void *get_shared_mem(size_t bytes)
{
    shmid = shmget(IPC_PRIVATE, bytes, IPC_CREAT | 0777);
    if (shmid < 0) {
	fprintf(stderr, "Couldn't get shared memory\n");
	exit(EXIT_FAILURE);
    }
	
    void *ret = shmat(shmid, 0, 0);
    if (-1 == (ptrdiff_t)ret) {
	fprintf(stderr, "Couldn't attach shared memory\n");
	exit(EXIT_FAILURE);
    }
    return ret;
}

void destroy_shared_mem(void *addr, int shmid)
{
    shmdt((char *)addr);
    shmctl(shmid, IPC_RMID, 0);
    fprintf(stderr, "Destroyed shared memory\n");
}

void catch_int(int dummy)
{
    destroy_shared_mem(ptr, shmid);
    exit(EXIT_FAILURE);
}
		     
void *operator new(size_t s, void *addr)
{
    return addr;
}

void main(int argc, char **argv)
{
    if (argc == 1) {
	fprintf(stderr, "Usage: %s <iters>\n", argv[0]);
	exit(EXIT_FAILURE);
    }
    ptr = (long *)get_shared_mem(sizeof(long));
    *ptr = 0;
    int i;
    int n = atoi(argv[1]);
    if (fork() != 0) {
	signal(SIGINT, catch_int);

	int j, i2;
	for (j = 0; j<n; j++)  {
	    while (((*ptr) & 1) == 0) sched_yield();
	    *ptr = *ptr + 1;
	}
	fprintf(stderr, "Received all values\n");

    } else {
	int j, i2;

	for (j = 0; j<n; j++)  {
	    while (((*ptr) & 1) == 1) sched_yield();
	    *ptr = *ptr + 1;
	}

	shmdt((char *)ptr);
	exit(0);
    }
    int *dummy;
    (void)wait(dummy);
    destroy_shared_mem(ptr, shmid);
}
