/* Copyright Barbara Liskov 1995 */

#include "common/basic.h"
#include "types/type.h"
#include "types/class.h"
#include "runtime/except.h"
#include "types/string_class.h"
#include "types/pclass_class.h"
#include "boot/wellknown.h"
#include "runtime/alloc.h"
#include "types/any.h"
#include "types/str.h"
#include "common/or_num.h"
class_ _get_root_rtn_classV;

/* from fe/cache/net.h */
extern obj cache_fetch_root (OR_num, void*);

any _get_root(obj dummy, int or)
{
    if (or == 0) {
	/* Get root of initial or */
	string s = string_new("root");
	return get_wellknown(s);
    } else {
        /* Get root of OR number or */
	obj root = cache_fetch_root((OR_num)or, 0);
        if (root)
	    return obj_as_any(root);
    }
    exc = &exc_not_found;	
}

struct _get_root_rtn_classdv_s {
   struct dv_s super;
   any (*_get_root)(obj self, int or);
};
class_ _get_root_rtn_classV;
struct _get_root_rtn_classdv_s _get_root_rtn_class_methods = {
  { 0, 0, STD_FOFFSET, 0, 0,
    normal_get_address, normal_get_class },
    (any (*)(obj self, int or)) _get_root};


#include "types/class_class.h"

DV _get_root_rtn_class_DH[] = { (DV)&_get_root_rtn_class_methods };
void init_get_root_rtn_class()
{
_get_root_rtn_classV->dh = _get_root_rtn_class_DH;
_get_root_rtn_classV->dhsize = 1;
_get_root_rtn_class_methods.super.c = _get_root_rtn_classV;
}
