/* Copyright Barbara Liskov 1995 */

#include "array_class.h"
#include "class_instn.h"
#include "vec_class.h" /* need class for speedy items access */
#include "sequence_class.h" /* need class for speedy items access */
#include "textwr.h"

/* XXX includes associated with hacked-up instantiation machinery */
#include "pclass.h"
#include "string_class.h"
#include "objtype_class.h"
#include "class_instn_class.h"
#include <string.h>
#include "bool.h"
#include "char.h"
#include "int.h"
#include "boot/wellknown.h"
#include "vec_instns.h"
/* XXX end */

#include "runtime/except.h"
#include "runtime/alloc.h"
#include "common/th_assert.h"
#include "common/other_unix.h"


/* "vec_class" is included because we make use of some private
   knowledge of the structure of vecs. */

/* Concurrency control for array and vec:
   We avoid marking both array and vec on a read (FIXUPREAD) 
   by marking only the array. This suffices because the vec contained
   in an array can only be accessed (read/modified) through the array.
   It does require that operations like store mark the array as written,
   although it is the contained vec that is really modified.
   We retain write-marking for the contained vec because that is useful for
   saving the base version and sending the modified version.
   */

pclass Array;

extern struct exception_s exc_bounds;
extern struct exception_s exc_negative_size;

static void predict(array a, int size);
static pval fetch(array a, int i);
static void store(array a, int, pval);
static void append(array a, pval);
static int length(array a);
static void trim(array a, int internal_low, int l);
static array subarray(array a, int first, int length);
static void concat(array, array);
static void append_iter(array, struct closure);
static pval array_remove_(array);
static array extract(array, int, int);

struct parg_env {
	type t;
	};
void get_parg_type(struct parg_env *env, type t);

static class_ get_class(obj a)
{
    return (*a)->c;
}

#if 0
struct arrayE_dv_s arrayE_methods_s = {
    {
	0, 0, STD_FOFFSET, 0,
	0, /* This field needs to be overridden */
	normal_get_address,
	normal_get_class
    },
    array_new,
    0 /* This field needs to be overridden */,
    0 /* This field needs to be overridden */
};
#endif

extern struct arraydv_s array_methods;

array array_new(obj dummy, class_instn aci)
{
    array_C ret = NEW(struct array_s);
    bool prim = FALSE;
    struct closure cl;
    struct parg_env env;
    class_ c = class_instn_as_class(aci);
    int bf;
    struct arraydv_s *am;

    cl.env = &env;
    cl.f = (ifunc)get_parg_type;
    aci->hdr.methods->pargs(aci, cl);
    /* Now, env.t has the type of the object in the array... */
    if (type_kind(env.t) == PRIMITIVE_KIND) prim = TRUE;

    /* init_obj_hdr((obj)ret, class_instn_as_class(aci)); */
    bf = UNPV(int, vec_fetch(c->bitfields, 0));
    init_obj_hdr_prim(&ret->hdr.inh, 3, bf,
                (DV)(*(class_instn_as_class(aci)->dh)));

    /* initialize instance variables */
    am = (struct arraydv_s *)(*(class_instn_as_class(aci)->dh));
    /* Ideally, initialize elems to 0.
       Since this breaks code that expects a reference, 
       put a reference to self as a filler.
       XXX This is a type error, but it should not affect correctness. */
    ret->elems = (vec) ret;
    ret->internal_size = 0;
    ret->user_size = 0;
    ret->internal_low = 0;
    ret->user_low = 1;

    return (array)ret;
}

array array_create(obj dummy, class_instn aci, int lb, sequence els)
/* XXX incorrect implementation, ignores lb */
{
    array a = array_new(dummy, aci);
    int i;

    int len = sequence_length(els);
    pval *items = sequence_items(els);
    array_predict(a, len);
    for (i = 0; i < len; i++) {
	array_append(a, items[i]);
    }
    return a;	
}

/* array_predict does more than its external spec claims, and
   this is needed by "append". It makes "elements" contain at least
   "size" spaces.
   */

void array_predict(array am, int size)
{
array_C a = ((array_C)am);

    a->hdr.methods->predict(am, size);
}

static void predict(array am, int size)
{
    array_C a = (array_C)am;

    vec elems;
    vec old = a->elems;
    int i;

    if (size < a->internal_size) size = a->internal_size;
    if (size == a->internal_size) return;
    /* elems = vecE_fill(a->hdr.methods->vec_info, size, 0); */
    FIXUPWRITE(&a->hdr.inh);
    elems = vec_new(0, (*am)->vci, size);
    if (a->user_size > 0) { 
	/* if user_size = 0, old may point to self; see array_new */
	FIX(old,vec);
	memcpy(elems->items,
	       &(old->items[0]),
	       a->user_size * FE_SLOT_SIZE);
	THOR_FREE(old);
    }
    a->elems = elems;
    a->internal_size = size;
    /* Fill in the blank slots with some object to avoid breaking code that
       expects references. Use the vec object itself as a filler. */
    for (i = a->user_size; i < a->internal_size; i++) {
	vec_store(elems, i, (pval)elems);
    }
}

pval array_fetch(array am, int i)
{
array_C a = (array_C)am;

    return a->hdr.methods->fetch(am, i);
}

static pval fetch(array am, int i)
{
array_C a = (array_C)am;

    vec vc = a->elems;
    DISCOVER(vc, vec);
    FIXUPREAD(&a->hdr.inh);
    i = i - a->user_low;
    if (i < 0 || i > a->user_size - 1) {
	exc = &exc_bounds;
	return;
    }
    i = i + a->internal_low;
    /* return (*(vc->hdr.methods)->fetch) (vc, i); */
    FIX(a->elems,vec);
    vc = a->elems;
    /* FIXUPREAD(&vc->hdr.inh); not needed */
    DISCOVER(vc->items[i], pval)
    return vc->items[i];
}

pval array_top(array am)
{
array_C a = (array_C)am;

    return a->hdr.methods->top(am);
}

static pval top(array am)
{
array_C a = (array_C)am;

    DISCOVER(a->elems, vec);
    FIXUPREAD(&a->hdr.inh);
    if (a->user_size == 0) {
	exc = &exc_bounds;
	return;
	}
    return vec_fetch(a->elems, a->user_size - 1 + a->internal_low);
}

pval array_bottom(array am)
{
array_C a = (array_C)am;

    return a->hdr.methods->bottom(am);
}

static pval bottom(array am)
{
array_C a = (array_C)am;

    DISCOVER(a->elems, vec);
    FIXUPREAD(&a->hdr.inh);
    if (a->user_size == 0) {
	exc = &exc_bounds;
	return;
	}
    return vec_fetch(a->elems, a->internal_low);
}

void array_store(array am, int i, pval v)
{
array_C a = (array_C)am;

    a->hdr.methods->store(am,i,v);
}

static void store(array am, int i, pval v)
{
array_C a = (array_C)am;

    vec vc = a->elems;
    DISCOVER(vc, vec);
    FIXUPWRITE(&a->hdr.inh);
    if (i < a->user_low || i > a->user_low + a->user_size - 1) {
	exc = &exc_bounds;
	return;
	}
    (*(vc->hdr.methods)->store) 
	(vc, i - a->user_low + a->internal_low, v);
}

void array_append(array am, pval v)
{
array_C a = (array_C)am;

    a->hdr.methods->append(am,v);
}

static void append(array am, pval v)
{
    array_C a = (array_C)am;
    int i;
    if (a->user_size == a->internal_size) {
	array_predict(am, a->internal_size*2 + 1);
    }
    DISCOVER(a->elems, vec);
    FIXUPWRITE(&a->hdr.inh);
    vec_store(a->elems, a->user_size, v);
    a->user_size++;
}

void array_append_low(array am, pval v)
{
array_C a = (array_C)am;

    a->hdr.methods->append_low(am,v);
}

/*
 * Note: if internal_low is NOT 0 then this code should just add v in at
 * intenal_low-1.  However, we'll not change it yet.  PRJ
 */

static void append_low(array am, pval v)
{
array_C a = (array_C)am;
pval ith;
int i;

    if (a->user_size == a->internal_size) {
	array_predict(am, a->internal_size*2 + 1);
    }
    DISCOVER(a->elems, vec);
    FIXUPWRITE(&a->hdr.inh);
    for (i = a->user_size - 1 + a->internal_low; 
		i >= a->internal_low; i--) {
	ith = vec_fetch(a->elems, i);
	vec_store(a->elems, i+1, ith);
	}
    vec_store(a->elems, a->internal_low, v);
    a->user_low--;
    a->user_size++;
}

void array_trim(array am, int internal_low, int len)
{
array_C a = (array_C)am;

    a->hdr.methods->trim(am, internal_low, len);
}

static void trim(array am, int new_low, int new_count)
{
array_C a = (array_C)am;

    if (new_count < 0) {
	SIGNAL_EXC(exc_negative_size);
	return;
    	}
    if (new_low < a->user_low || new_low > a->user_low + a->user_size - 1) {
	SIGNAL_EXC(exc_bounds);
	return;
	}
    if (new_count > a->user_size) new_count = a->user_size;
    FIXUPWRITE(&a->hdr.inh);
    a->internal_low = a->internal_low + (new_low - a->user_low);
    a->user_size = a->user_size - (new_low - a->user_low);
    a->user_low = new_low;
    if (a->user_size == 0)
    	a->internal_low = 0;
}

void array_set_low(array am, int internal_low)
{
array_C a = (array_C)am;

    a->hdr.methods->set_low(am, internal_low);
}

static void set_low(array am, int new_low)
{
array_C a = (array_C)am;

    FIXUPWRITE(&a->hdr.inh);
    a->user_low = new_low;
}

int array_length(array am)
{
array_C a = (array_C)am;

    return a->hdr.methods->length(am);
}

static int length(array am)
{
array_C a = (array_C)am;

    FIXUPREAD(&a->hdr.inh);
    return a->user_size;
}

int array_low(array am)
{
array_C a = (array_C)am;

    return a->hdr.methods->low(am);
}

static int low(array am)
{
array_C a = (array_C)am;

    FIXUPREAD(&a->hdr.inh);
    return a->user_low;
}

int array_high(array am)
{
array_C a = (array_C)am;

    return a->hdr.methods->high(am);
}

static int high(array am)
{
array_C a = (array_C)am;

    FIXUPREAD(&a->hdr.inh);
    return a->user_low + a->user_size - 1;
}

static array subarray(array a, int f, int l)
{
    fail("not implemented");
}

static array extract(array a, int f, int l)
{
    fail("not implemented");
}


static void concat(array a, array b)
{
    fail("not implemented");
}


static void append_iter(array a, struct closure cl)
    {fail("not implemented");}


/* implement these where clauses are understood */
static bool similar(array a1, array a2)
    {fail("not implemented");}
static array copy(array a)
    {fail("not implemented");}

void get_parg_type(struct parg_env *env, type t)
{
	env->t = t;
}

static string str_unparse = 0;

string array_unparse(array am)
{
array_C a = (array_C)am;

    return a->hdr.methods->unparse(am);
}

static string unparse(array am)
{
array_C a = (array_C)am;
class_ c = get_obj_class((obj)a);
type t = class_as_type(c);
class_instn ci = type_as_class_instn(t);
struct closure cl;
struct parg_env env;
int i;
objtype o;
textwr tw = textwr_new();
wr w = textwr_as_wr(tw);
int limit;

    	FIXUPREAD(&a->hdr.inh);
	if (!str_unparse) str_unparse = string_new("unparse");
	wr_putChars(w, "[low: ");
	wr_putString(w, int_unparse(a->user_low));
	wr_putChars(w, ", size: ");
	wr_putString(w, int_unparse(a->user_size));
	wr_putChars(w, ":\n");
	cl.env = &env;
	cl.f = (ifunc)get_parg_type;
	ci->hdr.methods->pargs(ci, cl);
	/* Now, env.t has the type of the object in the array... */
	limit = a->internal_low - 1 + a->user_size;
	for (i = a->internal_low; i <= limit; i++) {
		o = UNPV(objtype, vec_fetch(a->elems, i));
		if (type_kind(env.t) == OBJECT_KIND) {
			fevalue tgm_ret[2];
			RESET_EXC
			getMethod(o, tgm_ret, str_unparse);
			CATCH {
				wr_putChars(w, "no rep");
				}
			else {
				/* method m  = (method) tgm_ret[0].o; */
				/* result = invoke(o, mtype, m, vargs); */
				/* wr_putString(w, result); */
				wr_putChars(w, "to be fixed");
				}
			}
		else if (type_kind(env.t) == PRIMITIVE_KIND) {
			if (!strcmp(string_charp(type_name(env.t)), "int")) {
				wr_putString(w, int_unparse((int)o));
				}
			else if (!strcmp(string_charp(type_name(env.t)), 
						"bool")) {
				wr_putString(w, bool_unparse((int)o));
				}
			else if (!strcmp(string_charp(type_name(env.t)), 
						"char")) {
				wr_putString(w, char_unparse((int)o));
				}
			else if (!strcmp(string_charp(type_name(env.t)), 
						"string")) {
				wr_putString(w, string_unparse((string)o));
				}
			else {
				wr_putChars(w, "no rep");
				}
			}
		if (i == limit) wr_putChars(w, "\n");
		else wr_putChars(w, ",\n");
		}
	wr_putChars(w, "]\n");
	return textwr_toString(tw);
}

/* implement these when iterators are understood */
static void elements(array a, struct closure cl)
    {fail("not implemented");}
static void indexes(array a, struct closure cl)
    {fail("not implemented");}

bool array_empty(array am)
{
array_C a = (array_C)am;

    a->hdr.methods->empty(am);
}

static bool empty(array am)
{
array_C a = (array_C)am;

    	FIXUPREAD(&a->hdr.inh);
	if (a->user_size == 0) return TRUE;
	else return FALSE;
}

bool array_equal(array a1, array a2)
{
array_C a = (array_C)a1;

    a->hdr.methods->equal(a1, a2);
}

static bool equal(array a1, array a2)
{
array_C a = (array_C)a1;

    	FIXUPREAD(&a->hdr.inh);
	if (a1 == a2) return TRUE;
	else return FALSE;
}

pval array_remove(array am)
{
array_C a = (array_C)am;

    a->hdr.methods->remove(am);
}

static pval array_remove_(array am)
{
array_C a = (array_C)am;
pval ret;

    	FIXUPWRITE(&a->hdr.inh);
	if (a->user_size == 0) {
		exc = &exc_bounds;
		return;
		}
	ret = vec_fetch(a->elems, 
		a->user_size - 1 + a->internal_low);
	a->user_size--;
	if (a->user_size == 0)
		a->internal_low = 0;
}

static pval array_remove_low(array am)
{
array_C a = (array_C)am;

    return a->hdr.methods->remove_low(am);
}

static pval remove_low(array am)
{
array_C a = (array_C)am;
pval ret;

    	FIXUPWRITE(&a->hdr.inh);
	if (a->user_size == 0) {
		exc = &exc_bounds;
		return;
		}
	ret = vec_fetch(a->elems, a->internal_low);
	a->internal_low++;
	a->user_low++;
	a->user_size--;
	if (a->user_size == 0)
		a->internal_low = 0;
	return ret;
}

static vec array_superc = 0;
static string vci_prefix = 0;
static vec no_bf = 0;
extern vec no_slottypes;

DV *array_dhs(class_instn aci, vec pargs)
{
class_ c = class_instn_as_class(aci);
vec array_ivars;
formal f;
string vci_nm;
class_instn vci;
any a;

        bool saved = normal_heap;
	DV *dh = (DV *)malloc(1*sizeof(DV));
	struct arraydv_s *am = (struct arraydv_s *)malloc
		(sizeof(struct arraydv_s));
        normal_heap = FALSE;
	bcopy((char*)&array_methods, (char*)am, sizeof(struct arraydv_s));
	am->super.c = class_instn_as_class(aci);
	gc_register_meta_root((obj*)&(am->super.c));
	am->t = UNPV(type, vec_fetch(pargs, 0));
	gc_register_meta_root((obj*)&(am->t));
	if (!vci_prefix) {
		vci_prefix = string_new("vec_OF_");
		gc_register_meta_root((obj*)&vci_prefix);
		}
	vci_nm = string_concat(vci_prefix, typenm2cnm(am->t));
	a = get_wellknown(vci_nm);
	CATCH {
		RESET_EXC;
		if (type_kind(am->t) != PARAM_KIND) {
			vci = pclass_instantiate_(Vec, pargs);
			am->vci = vci;
			gc_register_meta_root((obj*)&(am->vci));
			}
		}
	else {
		am->vci = (class_instn)any_get_obj(a);
		gc_register_meta_root((obj*)&(am->vci));
	     }
	c->special = TRUE;
	c->specialText = string_empty();
	if (!array_superc) {
		array_superc = make_vec_Type(0, FALSE);
		gc_register_meta_root((obj*)&array_superc);
		}
	c->superclass = array_superc;
	array_ivars = make_vec_Formal(5, FALSE);
	c->fields = array_ivars;

	f = new_formal();
	f->name = string_new("elems");
	f->t = class_as_type(class_instn_as_class(am->vci));
	vec_store(array_ivars, 0, PV(f));

	f = new_formal();
	f->name = string_new("isize");
	f->t = class_as_type(Int);
	vec_store(array_ivars, 1, PV(f));

	f = new_formal();
	f->name = string_new("ilow");
	f->t = class_as_type(Int);
	vec_store(array_ivars, 2, PV(f));

	f = new_formal();
	f->name = string_new("usize");
	f->t = class_as_type(Int);
	vec_store(array_ivars, 3, PV(f));

	f = new_formal();
	f->name = string_new("ulow");
	f->t = class_as_type(Int);
	vec_store(array_ivars, 4, PV(f));
	
	normal_heap = saved;

	*dh = (DV)am;
	if (type_kind(am->t) == PARAM_KIND
		|| am->vci == 0) {
		if (!no_bf) {
			no_bf = make_vec_Int(0, FALSE);
			gc_register_meta_root((obj*)&no_bf);
			}
		c->bitfields = no_bf;
                if (!no_slottypes) {
			no_slottypes = make_vec_ObjType(0, FALSE);
                        gc_register_root((obj*)&no_slottypes);
		}
                c->slottypes = no_slottypes;
		return dh;
		}
	else {
		computeBitfields(c);
                if (!no_slottypes) {
                        no_slottypes = make_vec_ObjType(0, FALSE);
                        gc_register_root((obj*)&no_slottypes);
                }
                c->slottypes = no_slottypes;
		return dh;
		}
}

class_instn array_ci_get_vci(class_instn aci)
{
	class_ c = class_instn_as_class(aci);
	DV *dh = c->dh;
	struct arraydv_s *am = (struct arraydv_s *)(*dh);
	return am->vci;
	}

class_ array_new_rtn_classV;

struct array_new_rtn_classdv_s {
   struct dv_s super;
   array (*array_new)(obj self, class_instn aci);
};

struct array_new_rtn_classdv_s array_new_rtn_class_methods = {
  { 0, 0, STD_FOFFSET, 0, 0,
    normal_get_address, normal_get_class },
    (array (*)(obj self, class_instn aci)) array_new};

DV array_new_rtn_class_DH[] = { (DV)&array_new_rtn_class_methods };

void initarray_new_rtn_class()
{
array_new_rtn_classV->dh = array_new_rtn_class_DH;
array_new_rtn_classV->dhsize = 1;
array_new_rtn_class_methods.super.c = array_new_rtn_classV;
}



struct arraydv_s array_methods = {
    {
	0, 0, STD_FOFFSET, 0,
	0, /* This field needs to be overridden */
	normal_get_address,
	normal_get_class
    },
    fetch,
    store,
    length,
    elements,
    append,
    subarray,
    predict,
    array_remove_,
    trim,
    extract,
    concat,
    empty,
    low,
    high,
    bottom,
    top,
    append_low,
    remove_low,
    set_low,
    indexes,
    equal,
    similar,
    copy,
    unparse,
    append_iter,
    0,/* This field needs to be overridden */
    0 /* This field needs to be overridden */
};

DV Array_DH[] = {
    (DV)&array_methods
};

