/* Copyright Barbara Liskov 1995 */

#include "bool.h"
#include "runtime/obj_class.h"
#include "class_class.h"
#include "type.h"
#include "str.h"

bool bool_not(bool x)
{
    return x?FALSE:TRUE;
}

bool bool_equal(bool x, bool y)
{
    return x == y;
}

string bool_unparse(bool x)
{
    return x?string_new("true") : string_new("false");
}

bool bool_and(bool x, bool y)
{
    return x & y;
}

bool bool_or(bool x, bool y)
{
    return x | y;
}

bool bool_xor(bool x, bool y)
{
    return x ^ y;
}

bool bool_similar(bool x, bool y)
{
    return x == y;
}

bool bool_copy(bool x)
{
    return x;
}


struct booldv_s {
    struct dv_s super;
    bool (*not)(bool);
    bool (*equal)(bool, bool);
    string (*unparse)(bool);
    bool (*and) (bool, bool);
    bool (*or) (bool, bool);
    bool (*xor) (bool, bool);
    bool (*similar) (bool, bool);
    bool (*copy) (bool);
} bool_methods = {
    {0, 0, STD_FOFFSET, 0, 0, normal_get_address, normal_get_class},
    bool_not,
    bool_equal,
    bool_unparse,
    bool_and,
    bool_or,
    bool_xor,
    bool_similar,
    bool_copy
  };

DV Bool_dh[] = { (DV)&bool_methods };
     
void initBool()
{
    Bool->dh = Bool_dh;
    Bool->dhsize = 1;
    bool_methods.super.c = Bool;
}
