/* Copyright Barbara Liskov 1995 */

#include "runtime/alloc.h"
#include "common/basic.h"
#include "types/type.h"
#include "types/class.h"
#include "runtime/except.h"
#include "class_class.h"
#include "cell_class.h"
#include "cell.h"

class_ cellC;

IMPL_GET_CLASS(cellC)

struct celldv_s cell_methods = { 
  { 0, 0, STD_FOFFSET, 0, 0,
      normal_get_address,
      cellC_get_class },
  cell_put,
  cell_get
};

void cell_put(cell self, any value) {
  FIXUPWRITE(&self->hdr.inh);
  self->value_ = value;
  self->initialized_ = TRUE;
}

any cell_get(cell self) {
  any tmp;

  FIXUPREAD(&self->hdr.inh);
  if (self->initialized_)
    return DISCOVER_FAST(self->value_, any, tmp);
  else
    exc = &exc_empty;
}

cell new_cell() {
  cell res;

  res = (cell) NEW(struct cell_s);
  init_obj_hdr((obj) res, cellC);
  res->initialized_ = FALSE;
  res->t_ = 0;

  return res;
}

DV cell_DH[] = { (DV)&cell_methods };

void initcell() {
  cellC->dh = cell_DH;
  cellC->dhsize = 1;
  cell_methods.super.c = cellC;
}

#if PROMISES
void cell_put_type(cell self, type t) {
  FIXUPWRITE(&self->hdr.inh);
  self->t_ = t;
}

type cell_get_type(cell self) {
  type tmp;

  FIXUPREAD(&self->hdr.inh);
  return DISCOVER_FAST(self->t_, type, tmp);
}
#endif
