/* Copyright Barbara Liskov 1995 */

#ifndef _CELL_H
#define _CELL_H

#include "cell_def.h"
#include "runtime/obj.h"
#include "config/vdefs/PROMISES.h"

#ifdef __cplusplus
extern "C" {
#endif

/* A cell is a "thor variable" used by the client to store a thor */
/* value. */

extern cell new_cell();

extern void cell_put(cell self, any v);
/* Store a new value. */

extern any cell_get(cell self);
/* Get the value last stored.  Signals empty if no value has been */
/* stored. */

#if PROMISES
extern void cell_put_type(cell self, type t);
/* Store the apparant type of the contents of the cell.  This is a */
/* hack that is needed for type checking control structures.  When */
/* cell becomes a real parameterized type this should go away! */

extern type cell_get_type(cell self);
/* Get the apparant type of the contents of cell */

#endif

extern void initcell();

extern class_ cellC;

#ifdef __cplusplus
}
#endif

#endif /* _CELL_H */
