/* Copyright Barbara Liskov 1995 */

#ifndef _CLASS_H
#define _CLASS_H

#ifdef __cplusplus
extern "C" {
#endif

#include "types/type_def.h"
#include "common/iter.h"

extern class_ Class;

extern type class_as_type(class_);
/* A class is also a type. */

#ifndef __cplusplus
#define class_as_objtype(c) ((objtype)c)
#else
static inline objtype class_as_objtype(class_ c) { return (objtype)c; }
#endif

extern class_ objtype_as_class(objtype);
extern class_ type_as_class(type);
/*
   If this type is also a class, return it as a class. Otherwise,
   signal "not_possible".
*/

extern void class_fields(class_, struct closure);

/* Signature: fields(class) yields(string, type);
   
   Effect: Yield the fields of the class, including any fields inherited
   from the superclass. Superclass fields are yielded first. If the
   class is a primitive class, no fields will be yielded.
*/

extern class_ class_superclass(class_);
/*
   Return the superclass of this class. Signal "not_possible" if it
   has no superclass.
*/

#if 0
extern objtype class_extension_type(class_);
/*
   Return the declared type that specifies the extension operations
   of this class. This type will ordinarily not be related to the
   type that the class implements.
   Signal "not_possible" if this class has no extension object.
*/

extern class_ class_extension_class (class_);
/*
   Return the class that the extension operations can be invoked on.
   This object will be of the type returned by the "extension_type"
   method. Signal "not_possible" if the class has no extension object.
*/

extern obj class_get_object(class_ c);
/*
   If "c" is a class without any fields, create an object of this
   class. Otherwise, signal "not_possible". This method is used
   to bootstrap the creation of extension objects.
*/

extern type class_get_field_type(class_ c, string nm);
/*
   Look up nm in fields and return corresponding type.
   If none, return 0.
*/


#endif

#ifdef __cplusplus
}
#endif

#endif /* _CLASS_H */
