/* Copyright Barbara Liskov 1995 */

#ifndef _DICT_H
#define _DICT_H

#include "types/dict_def.h"
#include "runtime/except.h"
#include "common/iter.h"
#include "types/type.h"
#include "types/any.h"

#ifdef __cplusplus
extern "C" {
#endif


/* Overview: A dictionary is a mutable partial mapping from string to any. */

extern type Dict;

/* Creators */

dict dict_new();

/* Methods */

void dict_add(dict d, string key, any val);
/* Add a new mapping to the dictionary. Signals "duplicate" if
   the entry already exists.
*/

any dict_remove(dict d, string key);
/* Remove a mapping from the dictionary. Signals "not_found" if
   there is no entry for "key".
*/

bool dict_contains(dict d, string key);

any dict_fetch(dict d, string key);
/* Return the value corresponding to "key". Signal "not_found" if
   no such entry exists.
*/

void dict_keys(dict d, struct closure cl);
/* keys() yields(string)
   
  Yield all the keys for which "d" contains a mapping.
*/

void delete_dict(dict d);

#ifdef __cplusplus
}
#endif
    
#endif
