/* Copyright Barbara Liskov 1995 */

#include "class_class.h"
#include "type.h"
#include "vec.h"
#include "string.h"
#include "exception_class.h"
#include "runtime/alloc.h"
#include "runtime/obj_class.h"

struct Exceptiondv_s Exception_methods = 
  { { 0, 0, STD_FOFFSET, 0, 0,
      normal_get_address,
      normal_get_class
  },
    Exception_name,
    Exception_values
};

DV Exception_DH[] = { (DV)&Exception_methods };

void initException()
{
    ExceptionC->dh = Exception_DH;
    ExceptionC->dhsize = 1;
}


Exception new_Exception(string name, vec val)
{
    Exception e = NEW(struct Exception_s);
    init_obj_hdr_prim(&e->hdr.inh, 2, OBJ_BF_ALLREFS, Exception_DH[0]);
    e->name = name;
    e->values = val;
    return e;
}

/* Prototypes for the procedures doing the real work */

string Exception_name (Exception self) {
  FIX(self,Exception);
  return self->name;
}

vec Exception_values (Exception self) {
  FIX(self,Exception);
  return self->values;
}


