/* Copyright Barbara Liskov 1995 */

#ifndef _ILIST_H
#define _ILIST_H

#include "types/any.h"
#include "runtime/except.h"

typedef struct ilist_s *ilist;

/* Overview: ilist is a singly-linked mutable list of integers.
   A typical non-empty list is (in Prolog notation) "[H|T]", where "H" is
   the first item in the list and "T" is the remainder of the list.
*/

int ifirst(ilist x);
/* Return H[x]. Signal "empty" if the list is empty.
*/

ilist irest(ilist x);
/* Return T[x]. Signal "empty" if the list is empty.
*/

void iset_first(ilist x, int i);
/* Set  H[x] to be i. Signal "empty" if the list is empty.
*/

void iset_rest(ilist x, ilist y);
/* Set  T[x] to be y. Signal "empty" if the list is empty.
*/

void icons(ilist x, int i);
/* Append i to the front of the list. */

int ilength(ilist x);
/* Return the length of the list. */

#endif /* _ILIST_H */
