/* Copyright Barbara Liskov 1995 */

#ifndef _INSTN_H
#define _INSTN_H

#include "types/type_def.h"
#include "common/iter.h"

extern class_ Instn;
extern void init_Instn();

type instn_as_type(instn);
/*
  A simple cast, since type < instn
*/

instn type_as_instn(type);
/*
    If this object is really an "instn", view it as such. Otherwise,
    signal "not_possible".
*/
   
ptype instn_ptype(instn);
/*
    Return the parameterized type that it is an instantiation of.
*/

void instn_pargs(instn, struct closure);
/*
    Theta type: pargs() yields (Type)

    Yield the types that were passed as parameters to the instantiation.
*/

bool instn_equal(instn, instn);
/*
    Use ptype_ and pargs to check equality...
*/

#endif /* _INSTN_H */

