/* Copyright Barbara Liskov 1995 */

#include "intlist.h"
#include "ilist_meth.h"
#include "stdlib.h"
#include "runtime/obj.h"
#include "runtime/obj_class.h"
#include "common/iter.h"
#include "type.h"
#include "runtime/alloc.h"
#include "class_class.h"
#include "runtime/except.h"
#include "cache/gc_register.h"

class_ EmptyIntList, FullIntList;

typedef struct emptyint_s *emptyint;
typedef struct fullint_s *fullint;

extern struct exception_s exc_bounds;

struct emptyint_s {
    union {
	struct core_s inh;
	struct ilistdv_s *methods;
    } hdr;
};

struct fullint_s {
    union {
	struct core_s inh;
	struct ilistdv_s *methods;
    } hdr;
    int head;
    ilist tail;
};

static int fullint_first(ilist l)
{
    fullint f;
    f = (fullint)l;
    FIXUPREAD (&f->hdr.inh);
    return f->head;
}

static ilist fullint_rest(ilist l)
{
    fullint f;
    f = (fullint)l;
    FIXUPREAD (&f->hdr.inh);
    DISCOVER(f->tail, ilist);
    return f->tail;
}

static void fullint_set_first(ilist l, int i)
{
    fullint f;
    f  = (fullint)l;
    f->head = i;
    FIXUPWRITE (&f->hdr.inh);
}

static void fullint_set_rest(ilist x, ilist y)
{
    fullint f;
    f  = (fullint)x;
    f->tail = y;
    FIXUPWRITE (&f->hdr.inh);
}

static int emptyint_first(ilist l)
{
    exc = &exc_empty;
}

static ilist emptyint_rest(ilist l)
{
    exc = &exc_empty;
}

static void emptyint_set_first(ilist l, int i)
{
    exc = &exc_empty;
}

static void emptyint_set_rest(ilist x, ilist y)
{
    exc = &exc_empty;
}

class_ emptyint_list_get_class(obj l)
{
    return EmptyIntList;
}

class_ fullint_list_get_class(obj l)
{
    return FullIntList;
}

void intlist_cons(ilist self, int head)
{
/*
  fullint ret;

  FIXUPWRITE(&self->hdr.inh);
  ret = NEW(struct fullint_s);
  init_obj_hdr_prim(&ret->hdr.inh, 2, 0x3, (DV)&fullint_methods);
  ret->head = head;
  ret->tail = self;
  self = (ilist)ret;
  */
}

int intlist_length(ilist l)
{
    int count = 0;
    loop {
	l = irest(l);
	/* Will automatically result in setting the read bit in stamp */
	CATCH {
	    exc = EXC_NONE;
	    return count;
	}
	count++;
    }
}

struct ilistdv_s fullint_methods = {
    {0, 0, STD_FOFFSET, 0, 0, normal_get_address, normal_get_class},
    fullint_first,
    fullint_rest,
    fullint_set_first,
    fullint_set_rest,
    intlist_cons,
    intlist_length
  };

struct ilistdv_s emptyint_methods = {
    {0, 0, STD_FOFFSET, 0, 0, normal_get_address, normal_get_class},
    emptyint_first,
    emptyint_rest,
    emptyint_set_first,
    emptyint_set_rest,
    intlist_cons,
    intlist_length
  };

DV fullint_DH[] = {
    (DV)&fullint_methods
  };

DV emptyint_DH[] = {
    (DV)&emptyint_methods
  };

void initIntLists()
{
    FullIntList->dh = fullint_DH;
    FullIntList->dhsize = 1;
    EmptyIntList->dh = emptyint_DH;
    EmptyIntList->dhsize = 1;
    fullint_methods.super.c = FullIntList;
    emptyint_methods.super.c = EmptyIntList;
}

