/* Copyright Barbara Liskov 1995 */

#include "listProcs.h"
#include "list.h"
#include "common/iter.h"
#include "stdlist.h"
#include "class_class.h"

typedef struct listProcs_s *listProcs;

/*
 The standard list package
*/
extern list listProcs_cons(listProcs self, any head, list tail)
{
    return cons(head, tail);
}

extern list listProcs_empty(listProcs self)
/*
 Return an empty list
*/
{
    return empty_list();
}
extern list listProcs_reverse(listProcs self, list l)
/*
 Return a list containing all "l"'s elements in reverse order.
*/
{
    return stdlist_reverse(l);
}

extern any listProcs_elements(listProcs self, struct closure cl, list l)
/*
 Yield the elements of "l" in order, starting with "l.first()"
*/
{
    stdlist_elements(l, cl);
}

extern int listProcs_length(listProcs self, list l)
/*
 Return the number of elements in "l".
*/
{
    return stdlist_length(l);
}

struct listProcsdv_s {
  struct dv_s super;
  list (*listProcs_cons)(listProcs self, any head, list tail);
  list (*listProcs_empty)(listProcs self);
  list (*listProcs_reverse)(listProcs self, list l);
  any (*listProcs_elements)(listProcs self, struct closure, list l);
  int (*listProcs_length)(listProcs self, list l);
};

struct listProcs_s {
  union {
    struct core_s inh;
    struct listProcsdv_s *methods;
  } hdr;
};

extern struct listProcsdv_s listProcs_methods;

class_ ListProcs;

struct listProcsdv_s listProcs_methods = {
    { 0, 0, STD_FOFFSET, 0, 0,
	normal_get_address, normal_get_class},
    listProcs_cons,
    listProcs_empty,
    listProcs_reverse,
    listProcs_elements,
    listProcs_length
  };

DV ListProcs_dh[] = {(DV)&listProcs_methods};

void initListProcs()
{
    ListProcs->dh = ListProcs_dh;
    ListProcs->dhsize = 1;
}
