/* Copyright Barbara Liskov 1995 */


#ifndef _MAYBE_CLASS_H
#define _MAYBE_CLASS_H

typedef struct maybedv_s {
    struct dv_s super;
    bool (*is_full)(maybe m);
    bool (*is_empty)(maybe m);
    pval (*value_full)(maybe m);
    pval (*value_empty)(maybe m);
    bool (*equal)(maybe m1, maybe m2);
    bool (*similar)(maybe m1, maybe m2);
    maybe (*copy)(maybe m);
    string (*unparse)(maybe m);
    type t;
    class_instn mci;
    class_instn emci; 	/* corresponding empty maybe class instn */
}  *maybedv;

struct maybe_s {
    union {
        struct maybedv_s *methods;
        struct core_s inh;
    } hdr;
    any value;
    /* bool full; */
};

extern maybe maybe_new(obj dummy, class_instn mi, pval value);

#endif /* _MAYBE_CLASS_H */

