/* Copyright Barbara Liskov 1995 */

#include "vec.h"
#include "param.h"
#include "param_class.h"
#include "type.h"
#include "type_meth.h"
#include "runtime/obj_class.h"
#include "common/basic.h"
#include "common/th_assert.h"
#include "runtime/alloc.h"

class_ Param;

void param_supertypes(type t, struct closure cl)
{
    return;
}

bool param_isSubtype(type t1, type t2)
{
/* ORIGINAL:
    return (t1 == t2);

    XXX it should be put back, I think -- Andrew
*/
param p1, p2;

    if (t1 == t2) return TRUE;
    if (type_kind(t2) != PARAM_KIND) return FALSE;
    p1 = type_as_param(t1);
    p2 = type_as_param(t2);
    if (string_equal(p1->name, p2->name)) return TRUE;
    return FALSE;
}

void param_methods(type p_, struct closure cl)
{
    vec_elements(((param)p_)->methods_, cl);
}

string param_name(type p_)
{
    return ((param)p_)->name;
}

string param_unparse(type p_)
{
    return ((param)p_)->name;
}

int param_kind(type p_)
{
    return PARAM_KIND;
}

ptype param_ptype(param p)
{
    return p->ptype_;
}

bool param_equal(type t, type p2)
{
    return (same_obj((obj)t, (obj)p2))?TRUE:FALSE;
}

struct paramdv_s param_methods_dv = {
    {{0, 0, STD_FOFFSET, 0, 0,
	normal_get_address,
	normal_get_class},
       param_equal,
       param_supertypes,
       param_isSubtype,
       param_methods,
       param_name,
       param_unparse,
       param_kind
     },
	 param_ptype
       };

#include "class_class.h"

static DV Param_dh[] = {(DV)&param_methods_dv};

void init_Param()
{
    Param->dh = Param_dh;
    Param->dhsize = 1;
    param_methods_dv.super.super.c = Param;
}

param new_param()
{
/* param ret = NEW_META(struct param_s); */
param ret;
bool saved = normal_heap;

	ret = NEW_META(struct param_s);
	normal_heap = FALSE;
	init_param(ret);
	ret->methods_ = 0;
	normal_heap = saved;
	return ret;
}

void init_param(param p)
{
    init_obj_hdr_prim(&p->hdr.inh, PARAM_SLOTS, PARAM_BITFIELD,
		      (DV)&param_methods_dv);
}
