/* Copyright Barbara Liskov 1995 */

#ifndef _PARAM_H
#define _PARAM_H

#include "types/type_def.h"

extern class_ Param;
extern void init_Param();

/* Overview:

   A "param" is a conformant type. It describes a set of other types
   that have methods which conform to its method descriptions. A
   "param" is used as a type parameter. Any of the types that conform
   to the "param" can be supplied as an argument for that parameter.
*/

extern ptype param_ptype();
/* Return the parameterized type generator for which this type is a
   parameter.
*/

#define param_as_type(p) ((type)p)
#define type_as_param(p) ((param)p)
  
#endif /* _PARAM_H */
