/* Copyright Barbara Liskov 1995 */

#include <stdio.h>
#include "pclass_class.h"
#include "class_instn_class.h"
#include "ptype_class.h"
#include "array.h"
#include "vector.h"
#include "sequence.h"
#include "maybe.h"
#include "runtime/alloc.h"
#include "vec_class.h"
#include "vec_instns.h"
#include "textwr.h"
#include "string.h"
#include "string_class.h"
#include "cache/gc_register.h"

class_ PClass;
extern class_ Instn;

class_ pclass_superclass_(pclass pc);
extern instn ptype_instantiate_re_(ptype pt, vec args);
extern class_instn pclass_instantiate_(pclass pc, vec args);
void pclass_fields_(pclass pc, struct closure cl);
void save_incomplete(class_instn ci, pclass pc, vec args);
vec params_copy(vec p);
void log_instn_failure(class_instn ci);
void save_class_instn(pclass pc, vec v, class_instn ci);
class_instn lookup_ci_instn(pclass pc, vec v);

struct pclassdv_s pclass_methods = {
    {
	{
	    {
		{
		    0, 0, STD_FOFFSET, 0, 0,
		    normal_get_address, normal_get_class
		  },
		      objtype_equal_,
		      objtype_supertypes_,
		      objtype_isSubtype_,
		      objtype_methods_,
		      objtype_name_,
		      objtype_unparse_,
		      objtype_kind_,
		    },
			objtype_get_method_
		      },
			  ptype_instantiate_re_,
			  ptype_parameters_
			},
			    pclass_fields_,
			    pclass_superclass_,
			    pclass_instantiate_
			  };

pclass new_pclass()
{
pclass ret = NEW_META(struct pclass_s);
    bool saved = normal_heap;
    normal_heap = FALSE;
    init_pclass(ret);
    normal_heap = saved;
    return ret;
}

void init_pclass(pclass pc)
{
    init_ptype(&pc->hdr.inh);
    init_obj_hdr_prim(&pc->hdr.inh.hdr.inh.hdr.inh, PCLASS_SLOTS,
		      PCLASS_BITFIELD, (DV)&pclass_methods);
    pc->hdr.inh.hdr.inh.kind = PCLASS_KIND;
}

void pclass_fields(pclass pc, struct closure cl)
{
    pc->hdr.methods->fields(pc, cl);
}

void pclass_fields_(pclass pc, struct closure cl)
{
	vec fields = pc->fields;
	int i, n = vec_length(fields);
	formal *fields2 = VEC_ITEMS(fields, formal);
	void (*f)(void *env, string s, type t);
	void *env = cl.env;
	for (i = 0; i < n; i++) {
	    (*f)(env, fields2[i]->name, fields2[i]->t);
	    CHECK_BREAK_EXC;
	}
}

class_ pclass_superclass(pclass pc)
{
    return pc->hdr.methods->superclass(pc);
}

class_ pclass_superclass_(pclass pc)
{
    FIX_FAST(pc,pclass,pclass_methods);
    {
	if (vec_length(pc->superclass) == 0) {
	    exc = &exc_not_possible;
	    return;
	}
	return UNPV(class_, vec_fetch(pc->superclass, 0));
    }
}

instn ptype_instantiate_re_(ptype pt, vec args)
{
    pclass pc = (pclass)pt;
    return class_instn_as_instn(pclass_instantiate_(pc, args));
}

static int boot_complete = 0;

extern void special_dhs(pclass pc, class_instn ci, vec args);

class_instn pclass_instantiate_(pclass pc, vec temp_args)
{
class_instn ci = lookup_ci_instn(pc, temp_args);
int size = vec_length(temp_args);
vec args;
int i;

    if (ci) return (ci);
    args = make_vec_Type(size, FALSE);
    for (i = 0; i < size; i++) {
	vec_store(args, i, vec_fetch(temp_args, i));
	}
   
    ci = new_class_instn();
    save_class_instn(pc, args, ci);
    init_class_instn(ci);
    init_instn_name(&pc->hdr.inh, &ci->hdr.inh.hdr.inh, args);
    ci->pargs = params_copy(args);
    ci->pclass_ = pc;
    if (boot_complete) {
    	validate_instn(class_as_objtype(class_instn_as_class(ci)), 
				pclass_as_ptype(pc), ci->pargs);
	CATCH { log_instn_failure(ci); RESET_EXC; return; }
    	complete_instn(class_as_objtype(class_instn_as_class(ci)), 
				pclass_as_ptype(pc), ci->pargs);
	CATCH { log_instn_failure(ci); RESET_EXC; return; }
	/* XXX put in dispatch headers for array,vector,sequence */
	special_dhs(pc, ci, ci->pargs);
	}
    else save_incomplete(ci, pc, ci->pargs);
    return ci;
}

extern pclass Array;
extern pclass Sequence;
extern pclass Vector;
extern pclass Maybe;
extern DV *Array_DH;
extern DV *Sequence_DH;
extern DV *Vector_DH;
extern DV *Maybe_DH;

void special_dhs(pclass pc, class_instn ci, vec args)
{
bool prim = FALSE;
type t = UNPV(type, vec_fetch(args, 0));

	if (type_kind(t) == PRIMITIVE_KIND) prim = TRUE;
	if (pc == Array) {
		class_ c  = class_instn_as_class(ci);
		c->dh = array_dhs(ci, args);
		c->dhsize = 1;
		}
	if (pc == Vec) {
		class_ c  = class_instn_as_class(ci);
		c->dh = vec_dhs(ci, args);
		c->dhsize = 1;
		}
	if (pc == Vector) {
		class_ c  = class_instn_as_class(ci);
		c->dh = vector_dhs(ci, args);
		c->dhsize = 1;
/*
		c->dh = Vector_DH;
		if (prim) c->bitfields = OBJ_BF_ALLDATA;
		else c->bitfields = OBJ_BF_ALLREFS;
*/
		}
	if (pc == Sequence) {
		class_ c  = class_instn_as_class(ci);
		c->dh = Sequence_DH;
		c->dhsize = 1;
/*
		if (prim) c->bitfields = OBJ_BF_ALLDATA;
		else c->bitfields = OBJ_BF_ALLREFS;
*/
		}
	if (pc == Maybe) {
                class_ c  = class_instn_as_class(ci);
                c->dh = maybe_dhs(ci, args);
                c->dhsize = 1;
		}
	if (pc == EmptyMaybe) {
                class_ c  = class_instn_as_class(ci);
                c->dh = empty_maybe_dhs(ci, args);
                c->dhsize = 1;
		}
	}

#define MAX_SAVE 300
static save_count = 0;
static class_instn ci_save[MAX_SAVE];
static pclass pc_save[MAX_SAVE];
static vec args_save[MAX_SAVE];

void save_incomplete(class_instn ci, pclass pc, vec args)
{
	if (save_count >= MAX_SAVE) {
		th_fail("pclass.c: increase MAX_SAVE and recompile");
		}
	ci_save[save_count] = ci;
	pc_save[save_count] = pc;
	args_save[save_count] = args;
	save_count++;
}

void complete_incomplete()
{
int i;
class_instn ci;
pclass pc;
vec args;

	boot_complete = 1;
	for (i = 0; i < save_count; i++) {
		ci = ci_save[i];
		pc = pc_save[i];
		args = args_save[i];
		validate_instn(class_as_objtype(class_instn_as_class(ci)),
                                pclass_as_ptype(pc), args);
		CATCH { log_instn_failure(ci); RESET_EXC; continue; }
		complete_instn(class_as_objtype(class_instn_as_class(ci)),
                                pclass_as_ptype(pc), args);
		CATCH { log_instn_failure(ci); RESET_EXC; continue; }
		/* XXX put in dispatch headers for array,vector,sequence */
		special_dhs(pc, ci, args);
		}
}

void log_instn_failure(class_instn ci)
{
class_ c = class_instn_as_class(ci);
objtype o = class_as_objtype(c);

	fprintf(stderr, "Complete instantiation failing for %s\n",
			string_charp(o->name));
	}

pclass ptype_as_pclass(ptype pt)
{
    if (get_obj_class(type_as_obj(ptype_as_type(pt))) == PClass ||
           get_obj_class(type_as_obj(ptype_as_type(pt))) == ClassInstn) {
        return (pclass)pt;
    } else {
        exc = &exc_not_possible;
    }
}

#define MAX_CI_INSTNS 500

static ci_instn_count = 0;
pclass ci_instns_pc[MAX_CI_INSTNS];
vec    ci_instns_pargs[MAX_CI_INSTNS];
class_instn ci_instns_ci[MAX_CI_INSTNS];

void save_class_instn(pclass pc, vec v, class_instn ci)
{
   if (ci_instn_count >= MAX_CI_INSTNS) {
		th_fail("pclass.c: increase MAX_CI_INSTNS and recompile");
		}

    ci_instns_pc[ci_instn_count] = pc;
    gc_register_meta_root((obj* )&ci_instns_pc[ci_instn_count]);

    ci_instns_pargs[ci_instn_count] = v;
    gc_register_meta_root((obj *)&ci_instns_pargs[ci_instn_count]);

    ci_instns_ci[ci_instn_count] = ci;
    gc_register_meta_root((obj *)&ci_instns_ci[ci_instn_count]);

    ci_instn_count++;
    }

class_instn lookup_ci_instn(pclass pc, vec v)
{
int i, j;
bool match;

    if (!boot_complete) return NULL;
    for (i = 0; i < ci_instn_count; i++) {
	if (ci_instns_pc[i] == pc) {
		match = TRUE;
		for (j = 0; j < vec_length(v); j++) {
			type p1 = UNPV(type, vec_fetch(v, j));
			type p2 = UNPV(type, vec_fetch(ci_instns_pargs[i], j));
			if (!isSubtype(p1, p2) || !isSubtype(p2, p1))
				{match = FALSE; break;}
			}
		if (match) return ci_instns_ci[i];
		}
	}
    return NULL;
}

/* convert a type name string from the form with '[]' to the form */
/* with '_OF_' and '_AND_' */
/* stolen from the compiler (type2nm) */

string typeExtNm2IntNm(string tname)
{
const char *tnm = string_charp(tname);
int i;

        textwr tw = textwr_new();
        wr w = textwr_as_wr(tw);
        int len = string_length(tname);
        for (i = 0; i < len; i++) {
                char c = tnm[i];
                switch (c) {
                        case '[': { wr_putChars(w, "_OF_"); break; }
                        case ',': { wr_putChars(w, "_AND_"); break; }
                        case ']': break;
                        case ' ': break;
                        default: { wr_putChar(w, c); break; }
                        }
                }
        wr_close(w);
        return textwr_toString(tw);
        }

/* return the internal name of a type
	i.e. convert from a name with '[' and ']' to a name in the builtins */

string typenm2cnm(type t)
{
string tname = type_name(t);
	return typeExtNm2IntNm(tname);
	}

string typeExtNm2SimpleNm(string tname)
{
const char *tn = string_charp(tname);

   char *cptr = index(tn, '[');
   if (cptr) {
        string ret = string_newn(tn, cptr-tn);
        return ret;
        }
   else return tname;
   }


vec PARAMS;

/* Not good code: more than one parameter should be handled... */
/* Possibly have instantiation code do vec allocation... */
vec params_copy(vec p)
{
vec newp = make_vec_Type(1, FALSE);
	vec_store(newp, 0, vec_fetch(p, 0));
	return newp;
	}

#include "class_class.h"

DV PClass_dh[] = { (DV)&pclass_methods };

void init_PClass()
{
    PARAMS = make_vec_Type(1, FALSE);  	/* XXXXXXX */
    PClass->dhsize = 1;
    PClass->dh = PClass_dh;
    pclass_methods.super.super.super.super.c = PClass;
}
