/* Copyright Barbara Liskov 1995 */

#ifndef _PMETHOD_H
#define _PMETHOD_H

#include "types/type_def.h"

void pmethod_args(method, typevec, struct closure);
/* yields(string, type) */

void pmethod_sigs(method, typevec, struct closure);
/* sigs() yields(string, list) where the list contains only types */

void pmethod_rets(method, typevec, struct closure);
/* rets() yields(type) */

bool pmethod_isIter(method);
/* Return whether the method is an iterator. */

int pmethod_index(method);
/* Return the index of this method, as used by "invoke".  */

bool pmethod_isParameterized(method);
     
#endif /* _PMETHOD_H */
