/* Copyright Barbara Liskov 1995 */

#include <stdio.h>
#include "common/basic.h"
#include "types/type.h"
#include "types/class.h"
#include "runtime/except.h"
#include "types/string_class.h"
#include "boot/wellknown.h"
#include "runtime/alloc.h"
#include "types/str.h"
#include "types/print.h"
class_ print_rtn_classV;

void print(obj dummy, string message)
{
int out_count = 0;
int len, stlen;
const char *cp;

	FIX_FAST(message,string,string_methods);
	len = string_length(message);
	cp = string_charp(message);
	while (1) {
		fprintf(stderr, cp);
		stlen = strlen(cp);
		out_count += stlen;
		if (out_count == len) break;
		fputc('\0', stderr);
		cp += stlen + 1;
		out_count += 1;
		}
}

struct print_rtn_classdv_s {
   struct dv_s super;
   void (*print)(obj self, string message);
};
class_ print_rtn_classV;
struct print_rtn_classdv_s print_rtn_class_methods = {
  { 0, 0, STD_FOFFSET, 0, 0,
    normal_get_address, normal_get_class },
    (void (*)(obj self, string message)) print};


#include "types/class_class.h"

DV print_rtn_class_DH[] = { (DV)&print_rtn_class_methods };
void initprint_rtn_class()
{
print_rtn_classV->dh = print_rtn_class_DH;
print_rtn_classV->dhsize = 1;
print_rtn_class_methods.super.c = print_rtn_classV;
}
