/* Copyright Barbara Liskov 1995 */

#include "real.h"
#include "str.h"
#include "runtime/obj_class.h"
#include <math.h>
#include <stdio.h>
#include <string.h>

#ifdef __osf__
#define TRUNCF truncf
#define FLOORF floorf
#define NINTF nintf
extern real nintf(real);
extern real floorf(real);
extern real truncf(real);
#else
real ftrunc(real);
#define TRUNCF ftrunc
real ffloor(real);
#define FLOORF ffloor
double rint(double);
#define NINTF rint
#endif

extern class_ Real;

typedef union f_or_l_u {
    real f;
    unsigned long l;
} f_or_l;

#define BINARY_REAL_OP(name,op) \
unsigned long real_##name(unsigned long x, unsigned long y) \
{ f_or_l ret, arg1, arg2; \
    arg1.l = x; arg2.l = y; \
    ret.f = arg1.f op arg2.f; \
    return ret.l; \
}

BINARY_REAL_OP(add, +)
BINARY_REAL_OP(sub, -)
BINARY_REAL_OP(mul, *)
BINARY_REAL_OP(div, /)

#define BINARY_REAL_COMP(name,op) \
bool real_##name(unsigned long x, unsigned long y) \
{ f_or_l arg1, arg2; \
  arg1.l = x; arg2.l = y; \
  return arg1.f op arg2.f; \
}

BINARY_REAL_COMP(equal, ==)
BINARY_REAL_COMP(lt, <)
BINARY_REAL_COMP(gt, >)
BINARY_REAL_COMP(ge, >=)
BINARY_REAL_COMP(le, <=)

int real_trunc(unsigned long x)
{
    f_or_l arg1; arg1.l = x;
    return (int)TRUNCF(arg1.f);
}

int real_round(unsigned long x)
{
    f_or_l arg1; arg1.l = x;
    return (int)NINTF(arg1.f);
}

int real_floor(unsigned long x)
{
    f_or_l arg1; arg1.l = x;
    return (int)FLOORF(arg1.f);
}

string real_unparse(unsigned long lf, int precision)
{
    char buf[100];
    f_or_l arg1; arg1.l = lf;
    if (precision > sizeof(buf) - 10) precision = sizeof(buf) - 10;
    /* 10 will be enough characters to fit the non-digit characters.
       6 should theoretically be sufficient. Why push it?
    */
    sprintf(buf, "%1.*g", precision, arg1.f);
    if (!strchr(buf, '.')) {
	int l = strlen(buf);
	buf[l] = '.';
	buf[l + 1] = 0;
    }
    return string_new(buf);
}
    
struct realdv_s {
    struct dv_s super;
    unsigned long (*add)(unsigned long, unsigned long);
    unsigned long (*sub)(unsigned long, unsigned long);
    unsigned long (*mul)(unsigned long, unsigned long);
    unsigned long (*div)(unsigned long, unsigned long);
    bool (*equal)(unsigned long, unsigned long);
    bool (*lt)(unsigned long, unsigned long);
    bool (*gt)(unsigned long, unsigned long);
    bool (*le)(unsigned long, unsigned long);
    bool (*ge)(unsigned long, unsigned long);
    int (*trunc)(unsigned long);
    int (*round)(unsigned long);
    int (*floor)(unsigned long);
    string (*unparse)(unsigned long, int precision);
} real_methods = {
    {0, 0, STD_FOFFSET, 0, 0, normal_get_address, normal_get_class},
    real_add,
    real_sub,
    real_mul,
    real_div,
    real_equal,
    real_lt,
    real_gt,
    real_le,
    real_ge,
    real_trunc,
    real_round,
    real_floor,
    real_unparse
  };

DV real_DH[] = {
    (DV)&real_methods
  };

#include "class_class.h"

void initReal()
{
    Real->dh = real_DH;
    Real->dhsize = 1;
    real_methods.super.c = Real;
}
