/* Copyright Barbara Liskov 1995 */

#include "vec_class.h"
#include "sequence_class.h"
#include "runtime/alloc.h"
#include "type.h"
#include "runtime/except.h"
#include "runtime/obj_class.h"
#include "class.h"
#include "class_instn.h"

pclass Sequence;
pclass SequenceE_class;

extern struct exception_s exc_bounds;

struct sequence_dv_s sequence_methods = {
  { 0, 0, STD_FOFFSET, 0, 
	0, /* To be overridden by instances */
	normal_get_address,
	normal_get_class,
      },
    sequence_fetch_,
    sequence_length_,
    sequence_elements_,
    sequence_empty_,
    sequence_replace_,
    sequence_append_,
    sequence_extract_,
    sequence_concat_,
    sequence_indexes_,
    sequence_equal_,
    sequence_similar_,
    sequence_copy_,
    sequence_unparse_
  };

struct sequenceE_dv_s {
    struct dv_s super;
    sequence (*empty)(sequenceE);
    sequence (*fill)(sequenceE, int, pval);
    sequence (*from_iter)(sequenceE, struct closure);
    type param_t;
    class_ sequence_class;
};
/* Dispatch vector for a "sequenceE" */

struct sequenceE_s {
    union {
	struct sequenceE_dv_s *methods;
	struct core_s inh;
    } hdr;
};

sequence sequenceE_empty(sequenceE ext) {
    sequenceE_fill(ext, 0, 0);
}
    
sequence sequenceE_fill(sequenceE ext, int length, pval item)
{
    struct sequenceE_dv_s *vem = ext->hdr.methods;
    int i;
    sequence_C ret = (sequence_C)make_sequence_prim(
			    PRIMITIVE_KIND == type_kind(vem->param_t),
			    length);
    inst_obj_hdr((obj)ret, vem->sequence_class);
    for(i = 0; i < length; i++) {
	ret->items[i] = item;
    }
    return (sequence)ret;
}

sequence make_sequence_prim(bool primitive, int length)
{
    vec ret;
    int i;
    ret = NEWVEC(length);
    init_obj_hdr_prim(&ret->hdr.inh,
		      length,
		      primitive ? OBJ_BF_ALLDATA :
			          OBJ_BF_ALLREFS,
		      (DV)&sequence_methods);
    return (sequence)ret;
}

pval sequence_fetch(sequence sm, int i) {
sequence_C s = (sequence_C)sm;

    sequencedv __dv;
    DISCOVER(s, sequence)
    __dv = s->hdr.methods;
    return (*__dv->fetch)(sm, i);
}

pval sequence_fetch_(sequence sm, int i) {
sequence_C s = (sequence_C)sm;

    if (i < s->hdr.inh.size && i >= 0) {
        DISCOVER(s->items[i], pval)
        return s->items[i];
    }
    else exc = &exc_bounds;
}

int sequence_length(sequence sm)
{
sequence_C s = (sequence_C)sm;

    sequencedv __dv;
    DISCOVER(s, sequence)
    __dv = s->hdr.methods;
    return (*__dv->length)(sm);
}

int sequence_length_(sequence sm)
{
sequence_C s = (sequence_C)sm;

    return s->hdr.inh.size;
}

bool sequence_empty(sequence sm)
{
sequence_C s = (sequence_C)sm;

    sequencedv __dv;
    DISCOVER(s, sequence)
    __dv = s->hdr.methods;
    return (*__dv->empty)(sm);
}

bool sequence_empty_(sequence sm)
{
sequence_C s = (sequence_C)sm;

    if (s->hdr.inh.size == 0) return TRUE;
    else return FALSE;
}

sequence sequence_replace(sequence sm, int i, pval val)
{
sequence_C s = (sequence_C)sm;

    s->hdr.methods->replace(sm,i,val);
}

sequence sequence_replace_(sequence sm, int i, pval val)
{
sequence_C s = (sequence_C)sm;
sequence_C ret;
bool prim;
int len;

    if (i < 1 || i > s->hdr.inh.size) {
	exc = &exc_bounds;
	return;
	}
    /* make a new sequence of the size of s */
    /* should have same prim/non-prim value */
    len = s->hdr.inh.size;
    prim = (OBJ_BITFIELD((obj) s) == OBJ_BF_ALLDATA)? TRUE: FALSE;
    ret = (sequence_C)make_sequence_prim(prim, len);
    /* copy elements */
    if (len) memcpy(ret->items, s->items, len);
    /* overwrite ith elt with val */
    ret->items[i-1] = val;
    return (sequence)ret;
}

sequence sequence_append(sequence sm, pval val)
{
sequence_C s = (sequence_C)sm;

    s->hdr.methods->append(sm,val);
}

sequence sequence_append_(sequence sm, pval val)
{
sequence_C s = (sequence_C)sm;

sequence_C ret;
bool prim;
int len;
    /* make a new sequence of the size of s + 1 */
    /* should have same prim/non-prim value */
    len = s->hdr.inh.size + 1;
    prim = (OBJ_BITFIELD((obj) s) == OBJ_BF_ALLDATA)? TRUE: FALSE;
    ret = (sequence_C)make_sequence_prim(prim, len);
    /* copy elements */
    if (len) memcpy(ret->items, s->items, len - 1);
    /* stuff in extra elt */
    ret->items[len-1] = val;
    return (sequence)ret;
}

sequence sequence_extract(sequence sm, int st, int len)
{
sequence_C s = (sequence_C)sm;

    s->hdr.methods->extract(sm,st,len);
}

sequence sequence_extract_(sequence sm, int st, int len)
{
sequence_C ret;
sequence_C s = (sequence_C)sm;

bool prim;

    /* make a new sequence of size len */
    /* should have same prim/non-prim value */
    prim = (OBJ_BITFIELD((obj) s) == OBJ_BF_ALLDATA)? TRUE: FALSE;
    ret = (sequence_C)make_sequence_prim(prim, len);
    /* copy appropriate elements */
    if (len) memcpy(ret->items, &(s->items[st-1]), len);
    return (sequence)ret;
}

sequence sequence_concat(sequence sm, sequence sm2)
{
sequence_C s = (sequence_C)sm;

    s->hdr.methods->concat(sm,sm2);
}

sequence sequence_concat_(sequence sm, sequence sm2)
{
sequence_C ret;
bool prim;
int len, s_size, s2_size;
sequence_C s = (sequence_C)sm;
sequence_C s2 = (sequence_C)sm2;


    /* make a new sequence of size = size(s) + size(s2) */
    /* should have same prim/non-prim value */
    s_size = s->hdr.inh.size;
    s2_size = s2->hdr.inh.size;
    len = s_size + s2_size;
    prim = (OBJ_BITFIELD((obj) s) == OBJ_BF_ALLDATA)? TRUE: FALSE;
    ret = (sequence_C)make_sequence_prim(prim, len);

    /* copy both sets of elements */
    if (s_size) memcpy(ret->items, s->items, s_size);
    if (s2_size) memcpy(&(ret->items[s_size-1]), s2->items, s2_size);
    return (sequence)ret;
}

void sequence_indexes(sequence sm, struct closure cl)
{
sequence_C s = (sequence_C)sm;

    s->hdr.methods->indexes(sm,cl);
}

void sequence_indexes_(sequence sm, struct closure cl)
{
sequence_C s = (sequence_C)sm;

    fail("Not implemented.");
}

bool sequence_equal(sequence sm, sequence sm2)
{
sequence_C s = (sequence_C)sm;

    s->hdr.methods->equal(sm, sm2);
}

bool sequence_equal_(sequence sm1, sequence sm2)
{
sequence_C s1 = (sequence_C)sm1;
sequence_C s2 = (sequence_C)sm2;

    fail("Not implemented.");
}

bool sequence_similar(sequence sm, sequence sm2)
{
sequence_C s = (sequence_C)sm;

    s->hdr.methods->similar(sm, sm2);
}

bool sequence_similar_(sequence sm1, sequence sm2)
{
sequence_C s1 = (sequence_C)sm1;
sequence_C s2 = (sequence_C)sm2;

    fail("Not implemented.");
}

sequence sequence_copy(sequence sm)
{
sequence_C s = (sequence_C)sm;

    s->hdr.methods->unparse(sm);
}

sequence sequence_copy_(sequence sm)
{
sequence_C s = (sequence_C)sm;

    fail("Not implemented.");
}

string sequence_unparse(sequence sm)
{
sequence_C s = (sequence_C)sm;

    s->hdr.methods->unparse(sm);
}

string sequence_unparse_(sequence sm)
{
sequence_C s = (sequence_C)sm;

    fail("Not implemented.");
}

pval *sequence_items(sequence sm)
{
sequence_C s = (sequence_C)sm;

    FIX(sm, sequence);
    return s->items;
}

void sequence_elements(sequence sm, struct closure cl)
{
sequence_C s = (sequence_C)sm;

    s->hdr.methods->elements(sm,cl);
}

void sequence_elements_(sequence sm, struct closure cl)
{
sequence_C s = (sequence_C)sm;

    void (*f)(void *, pval) = (void (*)(void *, pval))cl.f;
    void *env = cl.env;
    {
	int i, n = s->hdr.inh.size;
	pval *items = s->items;
	for (i = 0; i < n; i++) {
	    (*f)(env, *items++);
	    CHECK_BREAK_EXC;
	}
    }
}

DV Sequence_DH[] = {
    (DV)&sequence_methods
};

