/* Copyright Barbara Liskov 1995 */

#ifndef _SEQ_H
#define _SEQ_H

#include "types/type_def.h"
#include "types/sequence_def.h"
#include "runtime/value.h"
#include "runtime/pval.h"
#include "common/iter.h"

#ifdef __cplusplus
extern "C" {
#endif

/*
    Overview:

    A "sequence[T]" is an immutable array of values of type T,
    but of fixed length. The values are indexed in the same
    way as strings and arrays: 1-based.
*/

extern pclass Sequence;
extern void init_Sequence();

/*
   Note: because "sequence" has no where clause on T, the methods
   mostly do not require a parameter block.  Keep dreaming.
*/

sequence sequenceE_from_iter(sequenceE, struct closure els);
/*   Signature: sequenceE[T].from_iter(els: iter() yields(T)) returns(sequence[T])

   Effect: Create a new "sequence" containing the items generated by "els". 

   Note: If "els.f" is 0, the contents of the new sequence are
   undefined. Ordinary Theta code cannot make use of this fact.
*/

sequence sequenceE_empty(sequenceE);
/*
   Signature: sequenceE[T].empty() returns(sequence[T])

   Effect: Create a new empty "sequence[T]".
*/

sequence sequenceE_fill(sequenceE, int length, pval item);
/*
   Signature: sequenceE[T].fill(length: int, item: T) returns(sequence[T])

   Effect: Create a new "sequence[T]" of length "length", where every
   element is "item".
*/

extern pval sequence_fetch(sequence v, int i);
/* 
   Signature: sequence.fetch(i: int) returns(T)
   Effect: Fetch the "i"th element. Signal "bounds" if out of bounds.
*/

extern int sequence_length(sequence v);
/* 
   Signature: sequence.length(v) returns(int)
   Effect: Return the length of "v".
*/

extern void sequence_elements(sequence v, struct closure cl);
/* 
   Signature: sequence.elements() yields(T)
   Effect: Yield the elements of "v".
*/


#ifdef __cplusplus
}
#endif


#endif /* _SEQ_H */
