/* Copyright Barbara Liskov 1995 */

#ifndef _SEQ_CLASS_H
#define _SEQ_CLASS_H

#include "types/sequence.h"
#include "runtime/obj_class.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef struct sequence_dv_s {
    struct dv_s super;
    pval (*fetch)(sequence, int);
    int (*length)(sequence);
    void (*elements)(sequence, struct closure cl);
    bool (*empty)(sequence);
    sequence (*replace)(sequence, int, pval);
    sequence (*append)(sequence, pval);
    sequence (*extract)(sequence, int first, int len);
    sequence (*concat)(sequence, sequence);
    void (*indexes) (sequence, struct closure cl);
    bool (*equal) (sequence, sequence);
    bool (*similar) (sequence, sequence);
    sequence (*copy) (sequence);
    string (*unparse) (sequence);
    sequenceE ext;
} *sequencedv;
/* Dispatch sequencetor for a "sequence" */


struct sequence_s {
    union {
	struct core_s inh;
	struct sequence_dv_s *methods;
    } hdr;
    pval items[1]; /* Actual length specified at initialization */
};

pval *sequence_items(sequence v);
/* 
   Return a pointer to the actual storage of the "sequence", so that
   C code can manipulate the elements conveniently. Needless to say,
   this is a dangerous procedure. It does perform a surrogate check.
*/

sequence make_sequence_copy(type t, int length, void *address);
/*
   Make a sequence and copy the region of memory starting at "address" and
   extending for "length" elements into it. A dangerous, yet fast,
   procedure.
*/

sequence make_sequence_prim(bool primitive, int length);
/*
   Make a sequence of some unspecified type T, with length "length".
   The argument "primitive" indicates whether the type is a
   primitive, non-pointer type. This operation is reserved for
   the FE bootstrap process.

   XXX The object created by this process will cause a core dump if
   XXX its class is asked for.  A mechanism for patching these objects
   XXX needs to be designed.
*/


extern pval sequence_fetch_(sequence s, int i);
extern int sequence_length_(sequence s);
extern void sequence_elements_(sequence s, struct closure);
extern bool sequence_empty_(sequence s);
extern sequence sequence_replace_(sequence s, int i, pval val);
extern sequence sequence_append_(sequence s, pval val);
extern sequence sequence_extract_(sequence s, int first, int len);
extern sequence sequence_concat_(sequence s1, sequence s2);
extern void sequence_indexes_(sequence s, struct closure);
extern bool sequence_equal_(sequence s1, sequence s2);
extern bool sequence_similar_(sequence s1, sequence s2);
extern sequence sequence_copy_(sequence s);
extern string sequence_unparse_(sequence s);

/* 
   Non-surrogate-checking versions of the methods, for use by subclasses only
*/

#ifdef __cplusplus
}
#endif

#endif /* _SEQ_CLASS_H */
