/* Copyright Barbara Liskov 1995 */

#ifndef _STDLIST_H
#define _STDLIST_H

#include "common/iter.h"
#include "types/list.h"

extern class_ EmptyList, FullList;
extern type StdList;

list empty_list();
/* Create an empty list */

list cons(any head, list tail);
/* Return the list "[head|tail]" */

void stdlist_elements(list l, struct closure cl);
/* Yield the elements of "l" in order. */

list stdlist_reverse(list l);
/* Return a list containing all "l"'s elements in reverse order. */

int stdlist_length(list l);
/* Return the number of elements of "l". */

any stdlist_nth(list l, int i);
/* Get the "i"th list element. Signal "bounds" if no such element
   exists. */

extern void initLists();
/* Initialize the dispatch headers of the two standard "list" classes. */
     
extern struct empty_s *the_empty_list;
extern void initEmptyList();

#endif
