/* Copyright Barbara Liskov 1995 */

#include "objtype_class.h"
#include "method.h"
#include "str.h"
#include "string_class.h"
#include "list.h"
#include "stdlist.h"
#include "runtime/obj.h"
#include "runtime/except.h"
#include "runtime/alloc.h"
#include "vec_class.h"
#include "textwr.h"
#include "class_class.h"
#include "ptype_class.h"
#include "pclass_class.h"
#include "param.h"
#include "pclass.h"
#include "class_instn.h"
#include "int.h"
#include "bool.h"
#include "char.h"
#include "real.h"
#include "vecOfAny.h"
#include "cell.h"
#include "common/truefalse.h"

extern void initSignal();
extern void initNull();
extern void initFormal();

#include <stdio.h>
#include <stdlib.h>

type List, IList, Wr, Type;
objtype Any;
class_ String, Method, Char, Null, Int, Bool, Real, TextWr;
class_ Formal, Signal, FullList, FullIntList, EmptyList, EmptyIntList;
class_ ExceptionC, VecOfAny;

obj type_as_obj(type t)
{
    return (obj)t;
}

bool isSubtype(type t, type t2)
{
    typedv __dv = t->methods;
    return (*__dv->subtype)(t, t2);
}

string type_name(type t)
{
    typedv __dv = t->methods;
    return (*__dv->name)(t);
}

string type_unparse(type t)
{
    typedv __dv = t->methods;
    return (*__dv->unparse)(t);
}

void type_methods(type t, struct closure cl)
{
    typedv __dv = t->methods;
    (*__dv->methods)(t, cl);
}

type obj_as_type(obj x)
{
    class_ c = get_obj_class(x);
    assert(c && c == ObjType || c == Class || c == Instn || c == ClassInstn);
    return (type)x;
}

type obj_as_type2(obj x)
{
    class_ c = get_obj_class(x);
    assert(c && c == ObjType || c == Class || c == Instn || c == ClassInstn
	|| c == PClass || c == PType);
    return (type)x;
}

int type_kind(type t)
{
    return t->methods->kind(t);
}

char *kind_names[] = {
  "object",
  "primitive",
  "class",
  "instance",
  "class_instance",
  "param",
  "pclass",
  "ptype"
};

char *kind_name(int kind) {
  return kind_names[kind];
}
