/* Copyright Barbara Liskov 1995 */

#ifndef _TYPE_H
#define _TYPE_H

#ifdef __cplusplus
extern "C" {
#endif

#include "common/basic.h"
#include "common/iter.h"
#include "types/type_def.h"
#include "types/dict.h"
#include "runtime/except.h"
#include "runtime/obj.h"
#include "runtime/value.h"

extern objtype Any;
/* The universal supertype */

extern type List, IList, Wr;
/* Well-known types */

extern type Type;
/* The supertype of all types, corresponding to the C type "type" */

extern class_ ObjType, Method, String, TextWr, FullList, FullIntList, EmptyList, EmptyIntList, ExceptionC;
/* Some well-known classes */

extern class_ Instn, Param, Class, ClassInstn, Type_class, PClass,
              PType;

extern class_ Int, Char, Bool, Null, Real;

#define anyV Any
#define intV Int
#define charV Char
#define boolV Bool
#define charV Char
#define stringV String
#define nullV Null
#define realV Real
#define vecV Vec
#define arrayV Array
#define vectorV Vector
#define sequenceV Sequence
#define maybeV Maybe
#define empty_maybeV EmptyMaybe

/* Primitive classes */

extern class_ VecOfAny;

/* The type hierarchy:
    
\begin{verbatim}
            Any
            / \
           /   \
          /     \
        Int,     \
        Char,    /\
        Bool,   /  \
        etc.  Type, \
	      List,  User-defined object types
	     String,
	     PType
	     
   The hierarchy of type types and classes (only Type isb not a class):

              getMethod
         Type ===========> method
        / |
       /  |
      /   |
     |    |
     |  ObjType
     |    |  \
     |    |   \  
     |    |    \     instantiate        getMethod
  Param Class Instn  <========== PType ===========> PMethod;
          \     |                  |
	   \    |                  |
	    \   |                  |
	     \  |    instantiate   |
	  ClassInstn <========== PClass

\end{verbatim}

*/

bool isSubtype(type t1, type t2);

bool type_equal(type t1, type t2);
/*
    The obvious semantics.
*/

void type_methods(type t, struct closure);
/*
    Yield those methods of "t" that are new in "t", i.e. they do not
    come from any of its supertypes.
*/


string type_name(type);
/* Return the name of the type */

string type_unparse(type);
/* Return a readable string representation of the type. */

void type_supertypes(type, struct closure);
/* Yield the immediate supertypes. */

int type_kind(type);
#define OBJECT_KIND 0
#define PRIMITIVE_KIND 1
#define CLASS_KIND 2
#define INSTN_KIND 3
#define CLASS_INSTN_KIND 4
#define PARAM_KIND 5
#define PCLASS_KIND 6
#define PTYPE_KIND 7
/* Return what kind of type this is. Currently known kinds are
   OBJECT_KIND: ordinary object type
   PRIMITIVE_KIND: primitive type (int, bool, char, null, real)
   CLASS_KIND: object class
   INSTN_KIND: parameterized type instantiation
   CLASS_INSTN_KIND: parameterized class instantiation
   PARAM_KIND: a parameter type
   PCLASS_KIND: a paramterized class (not actually a type)
   PTYPE_KIND: a paramterized type (not actually a type)

   Other kinds of types that may be supported soon are records, structs,
   oneofs. As this method demonstrates, enumeration types would also be
   nice.

   Values of primitive types are not stored in the heap, and take up a variable
   amount of space in the containing object.
*/

extern char *kind_name(int kind);
/* Return a string describing kind. */ 

#ifndef __cplusplus
extern obj type_as_obj(type);
/* Return a "type" as an "obj". Just does a cast.  */
#else
static inline obj type_as_obj(type t) { return (obj)t; }
#endif

#ifndef __cplusplus
#define objtype_as_type(ot) ((type)ot)
#else
static inline type objtype_as_type(objtype ot) { return (type)ot; }
#endif

extern type obj_as_type(obj);
/*
  It is a checked runtime error to pass an "obj" that is not actually a
  "type".
*/

extern type obj_as_type2(obj);
/*
  It is a checked runtime error to pass an "obj" that is not actually a
  "type".  Also allows pclasses and ptypes.
*/


#ifdef __cplusplus
}
#endif

#endif /* _TYPE_H */
