/* Copyright Barbara Liskov 1995 */

#ifndef _TYPE_METH_H
#define _TYPE_METH_H

#include "common/iter.h"
#include "types/type_def.h"
#include "runtime/obj_class.h"

typedef struct methoddv_s {
    struct dv_s super;
    void (*args)(method, struct closure);
    void (*sigs)(method, struct closure);
    void (*returns)(method, struct closure);
    bool (*isIter)(method);
    string (*name)(method);
    string (*unparse)(method);
    int (*index)(method);
    type (*self_type)(method);
} *methoddv;

extern struct methoddv_s method_methods;

typedef struct typedv_s {
    struct dv_s super;
    bool (*equal)(type, type);
    void (*supertypes)(type, struct closure);
    bool (*subtype)(type, type);
    void (*methods)(type, struct closure);
    string (*name)(type);
    string (*unparse)(type);
    int (*kind)(type);
} *typedv;

struct type_s {
    typedv methods;
};

extern struct typedv_s type_methods_dv;
#endif /* _TYPE_METH_H */
