/* Copyright Barbara Liskov 1995 */

#include "type.h"
#include "vecOfAny_class.h"
#include "vec_class.h"

struct vec_dv_s vecOfAny_methods = {
    { 0, 0, STD_FOFFSET, 0, 0,
	normal_get_address,
	normal_get_class},
    vec_fetch_,
    vec_store_,
    vec_length_
  };

any vecOfAny_fetch(vecOfAny self, int i) {
  return UNPV(any, vec_fetch((vec)self, i));
}

void vecOfAny_store(vecOfAny self, int i, any val) {
  vec_store((vec)self, i, PV(val));
}

int vecOfAny_length(vecOfAny self) {
  return vec_length((vec)self);
}


#include "class_class.h"

DV vecOfAny_DH[] = { (DV)&vecOfAny_methods };
void initvecOfAny()
{
  VecOfAny->dh = vecOfAny_DH;
  VecOfAny->dhsize = 1;
  vecOfAny_methods.super.c = VecOfAny;
}
