/* Copyright Barbara Liskov 1995 */

#include "vec_instns.h"
#include "vec_class.h"
#include "class_instn_class.h"
#include "objtype_class.h"
#include "any.h"
#include "runtime/alloc.h"
#include "str.h"

extern class_instn VecType;

/* break circular dependency */
extern struct vec_dv_s vec_Type_methods, vec_Class_methods; 

#define IMPL_make_vec(ARG, PRIM)                        \
class_instn Vec##ARG; 					\
class_instn VecE_##ARG##_c; 				\
vecE vecE_##ARG; 					\
\
struct vec_dv_s vec_##ARG##_methods = {\
    { 0, 0, STD_FOFFSET, 0,0,\
	normal_get_address,\
	normal_get_class\
    },\
    vec_fetch_,\
    vec_store_,\
    vec_length_, \
    vec_elements_, \
    0 \
  };\
\
vec make_vec_##ARG(int length, bool norm_heap)\
{\
    vec ret;\
    vec st; \
    vec sc; \
    bool saved = normal_heap;\
    normal_heap = norm_heap;\
    if (!Vec##ARG) {\
	bool saved2 = normal_heap;\
        normal_heap = FALSE;\
	Vec##ARG = new_class_instn();\
	init_class_instn(Vec##ARG);\
	assert(Vec && ARG); \
	st = make_vec_prim(TRUE, 1); \
	st->hdr.methods = &vec_Type_methods;\
        Vec##ARG->hdr.inh.hdr.inh.supertypes_ = st;\
        vec_store(st, 0, PV(Any)); \
	sc = make_vec_prim(TRUE, 0); \
	sc->hdr.methods = &vec_Class_methods;\
        Vec##ARG->hdr.inh.superclass = sc;\
	Vec##ARG->pclass_ = Vec;\
	Vec##ARG->pargs = make_vec_prim(TRUE, 1);\
	Vec##ARG->pargs->hdr.methods = &vec_Type_methods;\
        vec_store(Vec##ARG->pargs, 0, PV(ARG)); \
	vec_##ARG##_methods.super.c = class_instn_as_class(Vec##ARG);\
        normal_heap = saved2;\
    }\
    ret = make_vec_prim(PRIM, length);\
    ret->hdr.methods = &vec_##ARG##_methods;\
    normal_heap = saved;\
    return ret;\
}

IMPL_make_vec(Type, FALSE)
IMPL_make_vec(Param, FALSE)
IMPL_make_vec(Class, FALSE)
IMPL_make_vec(ObjType, FALSE)
IMPL_make_vec(Formal, FALSE)
IMPL_make_vec(Signal, FALSE)
IMPL_make_vec(Method, FALSE)
IMPL_make_vec(Int, TRUE)
IMPL_make_vec(Any, FALSE)
IMPL_make_vec(String, FALSE)

vec make_vec_simple(type t, int length)
{
  /* Note: the normal_heap global variable is being passed here */
#define IF(ARG) if (t == (type)ARG) return make_vec_##ARG(length, normal_heap);
    IF(Param)
    IF(Type)
    IF(Class)
    IF(ObjType)
    IF(Formal)
    IF(Signal)
    IF(Method)
    IF(Int)
    IF(Any)
    IF(String)
    fail("make_vec_simple called with unsupported type %s",
	 string_charp(type_name(t)));
}
