/* Copyright Barbara Liskov 1995 */

#ifndef _VEC_INSTNS_H
#define _VEC_INSTNS_H

#include "vec.h"
#include "class_instn.h"

#ifdef __cplusplus
extern "C" {
#endif
    
vec make_vec_simple(type t, int length);
/* For the types that "make_vec" is supported for below, return
   a vec that can be used to make calls on "make_vec". It is
   a checked runtime error to pass an unsupported type.
*/

vec make_vec_Param(int length, bool norm_heap);
vec make_vec_Class(int length, bool norm_heap);
vec make_vec_ObjType(int length, bool norm_heap);
vec make_vec_Type(int length, bool norm_heap);
vec make_vec_Formal(int length, bool norm_heap);
vec make_vec_Signal(int length, bool norm_heap);
vec make_vec_Method(int length, bool norm_heap);
vec make_vec_Int(int length, bool norm_heap);
vec make_vec_Any(int length, bool norm_heap);
vec make_vec_String(int length, bool norm_heap);

/* Exported for use for soon-to-be-obsolete clients. Don't use
   unless you want to be obsolete, too. */
extern struct make_vec_pblock_s vec_Any_make_pblock, vec_Type_make_pblock;

#ifdef __cplusplus
}
#endif

#endif /* _VEC_INSTNS_H */
