/* Copyright Barbara Liskov 1995 */

#include "vec_class.h"
#include "vec_instns.h"
#include "vector_class.h"
#include "runtime/alloc.h"
#include "type.h"
#include "runtime/except.h"
#include "runtime/obj_class.h"
#include "class.h"
#include "class_instn.h"
#include "class_instn_class.h"
#include "config/vdefs/EDGE_MARKING.h"
#include "cache/gc_register.h"

pclass Vector;
pclass VectorE_class;

extern struct exception_s exc_bounds;

struct vector_dv_s vector_methods = {
  { 0, 0, STD_FOFFSET, 0, 
	0, /* To be overridden by instances */
	normal_get_address,
	normal_get_class,
      },
    vector_fetch_,
    vector_store_,
    vector_length_,
    vector_empty_,
    vector_indexes_,
    vector_elements_,
    vector_equal_,
    vector_similar_,
    vector_copy_,
    vector_unparse_
  };

struct vectorE_dv_s {
    struct dv_s super;
    vector (*empty)(vectorE);
    vector (*fill)(vectorE, int, pval);
    vector (*from_iter)(vectorE, struct closure);
    type param_t;
    class_ vector_class;
};
/* Dispatch vector for a "vectorE" */

struct vectorE_s {
    union {
	struct vectorE_dv_s *methods;
	struct core_s inh;
    } hdr;
};

vector vectorE_empty(vectorE ext) {
    vectorE_fill(ext, 0, 0);
}
   
struct parg_env {
        type t;
        };
extern void get_parg_type(struct parg_env *env, type t);
 
vector vector_fill(obj dummy, class_instn vci, int length, pval item)
{
    int i;
    vector_C ret = (vector_C)NEWVEC(length);
    bool prim = FALSE;
    type t;

    t = UNPV(type, vec_fetch(vci->pargs, 0));
    if (type_kind(t) == PRIMITIVE_KIND) prim = TRUE;
    init_obj_hdr_prim(&ret->hdr.inh, length,
		prim ? OBJ_BF_ALLDATA : OBJ_BF_ALLREFS,
		(DV)(*(class_instn_as_class(vci)->dh)));

    for(i = 0; i < length; i++) {
	ret->items[i] = item;
    }
    return (vector)ret;
}

vector vectorE_fill(vectorE ext, int length, pval item)
{
    struct vectorE_dv_s *vem = ext->hdr.methods;
    int i;
    vector ret = make_vector_prim(PRIMITIVE_KIND == type_kind(vem->param_t),
			    length);
    inst_obj_hdr((obj)ret, vem->vector_class);
    for(i = 0; i < length; i++) {
	((vector_C)ret)->items[i] = item;
    }
}

vector make_vector_prim(bool primitive, int length)
{
    vec ret;
    int i;
    ret = NEWVEC(length);
    init_obj_hdr_prim(&ret->hdr.inh,
		      length,
		      primitive ? OBJ_BF_ALLDATA :
			          OBJ_BF_ALLREFS,
		      (DV)&vector_methods);
    return (vector)ret;
}

pval vector_fetch(vector vm, int i) {
vector_C v = (vector_C)vm;

    vectordv __dv;
    DISCOVER(v, vector)
    __dv = v->hdr.methods;
    return (*__dv->fetch)(vm, i);
}

pval vector_fetch_(vector vm, int i) {
vector_C v = (vector_C)vm;

    FIXUPREAD(&v->hdr.inh);
    if (i <= v->hdr.inh.size && i >= 1) {
        DISCOVER(v->items[i-1], pval)
        return v->items[i-1];
    }
    else exc = &exc_bounds;
}

void vector_store(vector vm, int i, pval val) {
vector_C v = (vector_C)vm;

    vectordv __dv;
    DISCOVER(v, vector)
    __dv = v->hdr.methods;
    (*__dv->store)(vm, i, val);
}

void vector_store_(vector vm, int i, pval val) {
vector_C v = (vector_C)vm;

    FIXUPWRITE(&v->hdr.inh);
    if (i <= v->hdr.inh.size && i >= 1) {
        DISCOVER(v->items[i-1], pval)
        v->items[i-1] = val;
    }
    else exc = &exc_bounds;
}

int vector_length(vector vm)
{
vector_C v = (vector_C)vm;

    vectordv __dv;
    DISCOVER(v, vector)
    __dv = v->hdr.methods;
    return (*__dv->length)(vm);
}

int vector_length_(vector vm)
{
vector_C v = (vector_C)vm;

    FIXUPREAD(&v->hdr.inh);
    return v->hdr.inh.size;
}

bool vector_empty(vector vm)
{
vector_C v = (vector_C)vm;

    vectordv __dv;
    DISCOVER(v, vector)
    __dv = v->hdr.methods;
    return (*__dv->empty)(vm);
}

bool vector_empty_(vector vm)
{
vector_C v = (vector_C)vm;

    if (v->hdr.inh.size == 0) return TRUE;
    else return FALSE;
}

void vector_indexes(vector vm, struct closure cl)
{
vector_C v = (vector_C)vm;

    v->hdr.methods->indexes(vm,cl);
}

void vector_indexes_(vector vm, struct closure cl)
{
vector_C v = (vector_C)vm;

    fail("Not implemented.");
}

bool vector_equal(vector vm, vector vm2)
{
vector_C v = (vector_C)vm;

    v->hdr.methods->equal(vm, vm2);
}

bool vector_equal_(vector vm1, vector vm2)
{
vector_C v1 = (vector_C)vm1;
vector_C v2 = (vector_C)vm2;

    fail("Not implemented.");
}

bool vector_similar(vector vm, vector vm2)
{
vector_C v = (vector_C)vm;

    v->hdr.methods->similar(vm, vm2);
}

bool vector_similar_(vector vm1, vector vm2)
{
vector_C v1 = (vector_C)vm1;
vector_C v2 = (vector_C)vm2;

    fail("Not implemented.");
}

vector vector_copy(vector vm)
{
vector_C v = (vector_C)vm;

    v->hdr.methods->unparse(vm);
}

vector vector_copy_(vector vm)
{
vector_C v = (vector_C)vm;

    fail("Not implemented.");
}

string vector_unparse(vector vm)
{
vector_C v = (vector_C)vm;

    v->hdr.methods->unparse(vm);
}

string vector_unparse_(vector vm)
{
    fail("Not implemented.");
}

pval *vector_items(vector vm)
{
vector_C v = (vector_C)vm;

    FIXUPREAD(&v->hdr.inh);
    FIX(vm, vector);
    return v->items;
}

void vector_elements(vector vm, struct closure cl)
{
vector_C v = (vector_C)vm;

    v->hdr.methods->elements(vm,cl);
}

void vector_elements_(vector vm, struct closure cl)
{
vector_C v = (vector_C)vm;

    void (*f)(void *, pval) = (void (*)(void *, pval))cl.f;
    void *env = cl.env;
    FIXUPREAD(&v->hdr.inh);
    {
	int i, n = v->hdr.inh.size;
	pval *items = v->items;
	for (i = 0; i < n; i++) {
	    (*f)(env, *items++);
	    CHECK_BREAK_EXC;
	}
    }
}

static vec vector_superc = 0;
extern vec no_slottypes;


DV *vector_dhs(class_instn vci, vec pargs)
{
class_ c = class_instn_as_class(vci);
vec vector_ivars;
formal f;
type t = UNPV(type, vec_fetch(pargs, 0));
bool prim;
vec bf;
bool saved;

	DV *dh = (DV *)malloc(1*sizeof(DV));
        struct vector_dv_s *vm = (struct vector_dv_s *)malloc(
					sizeof(struct vector_dv_s));
        bcopy((char*)&vector_methods, (char*)vm, sizeof(struct vector_dv_s));
        vm->super.c = class_instn_as_class(vci);
	gc_register_meta_root((obj*)&vm->super.c);
        vm->t = t;
	gc_register_meta_root((obj*)&vm->t);
	c->special = TRUE;
	c->specialText = string_empty();
	if (!vector_superc) {
		vector_superc = make_vec_Type(0, FALSE);
		gc_register_meta_root((obj*)&vector_superc);
		}
	c->superclass = vector_superc;
	vector_ivars = make_vec_Formal(1, FALSE);
	c->fields = vector_ivars;
	f = new_formal();
	f->name = string_new("elems");
	f->t = t;
	vec_store(vector_ivars, 0, PV(f));
	if (type_kind(t) == PRIMITIVE_KIND) prim = TRUE;
	saved = normal_heap;
	normal_heap = FALSE;
	bf = make_vec_Int(1, FALSE);
	normal_heap = saved;
	if (prim) vec_store(bf, 0, PV(OBJ_BF_ALLDATA));
	else vec_store(bf, 0, PV(OBJ_BF_ALLREFS));
	c->bitfields = bf;
        if (!no_slottypes) {
            no_slottypes = make_vec_ObjType(0, FALSE);
            gc_register_root((obj*)&no_slottypes);
        }
        c->slottypes = no_slottypes;

	*dh = (DV)vm;
	return dh;
}

DV Vector_DH[] = {
    (DV)&vector_methods
};

