/* Copyright Barbara Liskov 1995 */

#ifndef _VECTOR_H
#define _VECTOR_H

#include "types/type_def.h"
#include "types/vector_def.h"
#include "runtime/value.h"
#include "runtime/pval.h"
#include "common/iter.h"

#ifdef __cplusplus
extern "C" {
#endif

/*
    Overview:

    A "vector[T]" is a mutable array of values of type T,
    but of fixed length. The values are indexed in the same
    way as strings and arrays: 1-based.
*/

extern pclass Vector;
extern void init_Vector();

/*
   Note: because "vector" has no where clause on T, the methods
   mostly do not require a parameter block.  Keep dreaming.
*/

vector vectorE_from_iter(vectorE, struct closure els);
/*   Signature: vectorE[T].from_iter(els: iter() yields(T)) returns(vector[T])

   Effect: Create a new "vector" containing the items generated by "els". 

   Note: If "els.f" is 0, the contents of the new vector are
   undefined. Ordinary Theta code cannot make use of this fact.
*/

vector vectorE_empty(vectorE);
/*
   Signature: vectorE[T].empty() returns(vector[T])

   Effect: Create a new empty "vector[T]".
*/

vector vectorE_fill(vectorE, int length, pval item);
/*
   Signature: vectorE[T].fill(length: int, item: T) returns(vector[T])

   Effect: Create a new "vector[T]" of length "length", where every
   element is "item".
*/

extern pval vector_fetch(vector v, int i);
/* 
   Signature: vector.fetch(i: int) returns(T)
   Effect: Fetch the "i"th element. Signal "bounds" if out of bounds.
*/

extern void vector_store(vector v, int i, pval val);
/* 
   Signature: vector.store(i: int, val:T)
   Effect: Updates the "i"th element. Signal "bounds" if out of bounds.
*/

extern int vector_length(vector v);
/* 
   Signature: vector.length(v) returns(int)
   Effect: Return the length of "v".
*/

extern void vector_elements(vector v, struct closure cl);
/* 
   Signature: vector.elements() yields(T)
   Effect: Yield the elements of "v".
*/

extern DV *vector_dhs(class_instn, vec);


#ifdef __cplusplus
}
#endif


#endif /* _VECTOR_H */
