/* Copyright Barbara Liskov 1995 */

#ifndef _VECTOR_CLASS_H
#define _VECTOR_CLASS_H

#include "types/vector.h"
#include "runtime/obj_class.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef struct vector_dv_s {
    struct dv_s super;
    pval (*fetch)(vector, int);
    void (*store)(vector, int, pval);
    int (*length)(vector);
    bool (*empty)(vector);
    void (*indexes) (vector, struct closure cl);
    void (*elements)(vector, struct closure cl);
    bool (*equal) (vector, vector);
    bool (*similar) (vector, vector);
    vector (*copy) (vector);
    string (*unparse) (vector);
    type t;
    vectorE ext;
} *vectordv;
/* Dispatch vector for a "vector" */


struct vector_s {
    union {
	struct core_s inh;
	struct vector_dv_s *methods;
    } hdr;
    pval items[1]; /* Actual length specified at initialization */
};

pval *vector_items(vector v);
/* 
   Return a pointer to the actual storage of the "vector", so that
   C code can manipulate the elements conveniently. Needless to say,
   this is a dangerous procedure. It does perform a surrogate check.
*/

vector make_vector_copy(type t, int length, void *address);
/*
   Make a vector and copy the region of memory starting at "address" and
   extending for "length" elements into it. A dangerous, yet fast,
   procedure.
*/

vector make_vector_prim(bool primitive, int length);
/*
   Make a vector of some unspecified type T, with length "length".
   The argument "primitive" indicates whether the type is a
   primitive, non-pointer type. This operation is reserved for
   the FE bootstrap process.

   XXX The object created by this process will cause a core dump if
   XXX its class is asked for.  A mechanism for patching these objects
   XXX needs to be designed.
*/


extern pval vector_fetch_(vector v, int i);
extern void vector_store_(vector v, int i, pval val);
extern int vector_length_(vector v);
extern void vector_elements_(vector v, struct closure);
extern bool vector_empty_(vector v);
extern vector vector_replace_(vector v, int i, pval val);
extern vector vector_append_(vector v, pval val);
extern vector vector_extract_(vector v, int first, int len);
extern vector vector_concat_(vector v1, vector v2);
extern void vector_indexes_(vector v, struct closure);
extern bool vector_equal_(vector v1, vector v2);
extern bool vector_similar_(vector v1, vector v2);
extern vector vector_copy_(vector v);
extern string vector_unparse_(vector v);

/* 
   Non-surrogate-checking versions of the methods, for use by subclasses only
*/

#ifdef __cplusplus
}
#endif

#endif /* _VECTOR_CLASS_H */
