// Copyright 1995 Barbara Liskov

#include "common/tstamp.h"
#include "common/or_set.h"
#include "thread.h"

#include "coord_set.h"

implementArray(CoordArray, CoordEntry *)

Coord_set::Coord_set() {
    set = new CoordArray;
    mutex = new Mutex;
}

Coord_set::~Coord_set() {
    delete set;
    delete mutex;
}

bool Coord_set::member(OR_num coord) {
    bool res = TRUE;
    mutex->grab(); {
	if (find(coord) == -1)
	    res = FALSE;
    } mutex->release();
    return res;
}

void Coord_set::add(OR_num coord, Tstamp t) {
    int index;

    mutex->grab(); {
	index = find(coord);
	if (index != -1)
	    set->slot(index)->tstamp = t;
	else {
	    CoordEntry* entry = new CoordEntry;
	    entry->or_num = coord;
	    entry->tstamp = t;
	    set->append(entry);
	}
    } mutex->release();
}

void Coord_set::truncate(Tstamp t, OR_set *ors) {
    int i = 0;
    mutex->grab(); {
	// This is a little tricky--remove elements from array as we scan it.
	while (i < set->size()) {
	    if (set->slot(i)->tstamp < t) {
		ors->add(set->slot(i)->or_num);
		int size = set->size();
		if (i != size - 1) {
		    delete set->slot(i);
		    set->slot(i) = set->slot(size - 1);
		}		    
		set->remove();   // Get rid of last element
	    }
	    else i++;
	}
    } mutex->release();
}

int Coord_set::find(OR_num or_num) {
    for (int i = 0; i < set->size(); i++)
	if (set->slot(i)->or_num == or_num)
	    return i;

    return -1;
}
