// Copyright 1995 Barbara Liskov

// 
//  \section{Implementation for set of per-FE info structures}
//

#include "common/fe_num.h"

#include "fe_info_set.h"
#include "rwlock_mutex.h"

implementArray(FE_info_array, FE_info *)

// \subsection{Public functions}

FE_info_set::FE_info_set()
{
    lock = new RW_lock_mutex;
    set = new FE_info_array;
}

FE_info_set::~FE_info_set()
{
    // Go through and delete all allocated items per FE
    FE_info *info;
    int size = set->size();
    for (int i = 0; i < size; i++) 
	free_FE_info(set->slot(i));
    delete lock;
    delete set;
}

FE_info *FE_info_set::add_FE (fe_num const& id, FE_manager *mgr) 
{
    FE_info *new_info = new FE_info;
    
    new_info->id = id;
    new_info->manager = mgr;
    new_info->fe_table = new FE_table;
    new_info->invalid_objs = new Invalid_set;
    new_info->lock = new RW_lock_mutex;
    new_info->max_message = new_info->current_message = 0;
    
    set->append(new_info);

    return new_info;
}

bool FE_info_set::remove_FE(fe_num const& id)
{
    int index = find(id);
    int size = set->size();
    if (index < 0)
	return FALSE;

    free_FE_info(set->slot(index));
    FE_info* last_element = set->remove();
    if (index != size - 1) 
	set->slot(index) = last_element;
    return TRUE;
}

FE_manager *FE_info_set::get_manager(fe_num const& id)
{
    int index = find(id);
    if (index < 0)
	return 0;
    return set->slot(index)->manager;
}
   
FE_info_set::Elements::Elements(FE_info_set* fe_info_set) 
{
   data = fe_info_set->set;
   index = 0;
}

bool FE_info_set::Elements::get(FE_info*& fe_info) 
{
    if (index >= data->size()) 
	return FALSE;
    fe_info = data->slot(index);
    index++;
    return TRUE;
}

// \subsection{Private functions}

void FE_info_set::free_FE_info(FE_info *info)
{
    delete info->fe_table;
    delete info->invalid_objs;
    delete info->lock;
    delete info;
}

int FE_info_set::find(fe_num const& id) 
{
    int size = set->size();

    for (int i=0; i < size; i++)
	if (set->slot(i)->id == id)
	    return i;
    return -1;
}

