// Copyright 1995 Barbara Liskov

// \section{OR initialization code}

#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/param.h>
#include <unistd.h>

#include "common/fail.h"
#include "common/th_assert.h"
#include "common/hostname.h"
#include "common/locator.h"

#include "mm/log.h"
#include "mm/mm.h"
#include "init.h"
#include "or.h"
#include "or_config.h"
#include "or_manager.h"
#include "tm.h"
#include "tstatus.h"

OR* or = 0;

static void init_locator(void);

void OR_init() {
    // Initialize various components of the OR

    // Must find our OR number before creating other components
    init_locator();
    or->or_managers = new OR_manager_set();
    or->log = new Log();         // Log must be initialized before TM.
    or->mm = new MM(TRUE);
    or->tm = new TM;
    or->tstatus = new Transaction_Status();
}

void OR_recover() {
    init_locator();
    or->or_managers = new OR_manager_set();
    or->log = new Log();
    or->mm = new MM(FALSE);
    or->tm = new TM;
    or->tstatus = new Transaction_Status();
}

static void init_locator(void)
{
    or->locator = new Locator;
    if (!or->locator->init())
    {
	fail("OR locator initialization failed!");
    }

    // Get my host name
    char hostname[MAXHOSTNAMELEN+1];
    if (gethostname(hostname, MAXHOSTNAMELEN+1) < 0)
	sysfail("or: could not find local host name");

    // Get my host address
    struct in_addr address;
    if (!findhost(hostname, &address))
	fail("or: could not find local IP address");

    or->config->ornum = or->locator->or_number(address.s_addr, 
					       or->config->port_offset);
    if (or->config->ornum == 0)
	fail("or: could not find itself in OR location table");
}
