// Copyright 1995 Barbara Liskov

#include <stdio.h>
#include <string.h>
#include "common/fail.h"
#include "dformat.h"

static bool valid_superblock(Disk_SB* s);
// effects - Return true iff s is a valid superblock.

bool Disk_ReadSuper(Disk* d, Disk_SB* super) {
    // Read the superblocks
    Disk_Range range;
    Disk_SB a, b;

    range.address = DISK_SB_1;
    range.count   = DISK_SB_SIZE;
    if (! d->read(&a, range)) return FALSE;

    range.address = DISK_SB_2;
    range.count   = DISK_SB_SIZE;
    if (! d->read(&b, range)) return FALSE;

    // Find correct superblock
    Disk_SB* correct;
    bool valid_a = valid_superblock(&a);
    bool valid_b = valid_superblock(&b);
    if (valid_a && valid_b)
	correct = (a.timestamp >= b.timestamp) ? &a : &b;
    else if (valid_a)
	correct = &a;
    else if (valid_b)
	correct = &b;
    else
	return FALSE;

    if (correct->magic != DISK_SB_MAGIC) {
	// Bad magic number
	warn("Bad magic number in OR super block.  Perhaps the OR format has");
	warn("changed since the database was created.");
	return FALSE;
    }

    memcpy(super, correct, sizeof(Disk_SB));

    int segsize = (super->segprefsize << DISK_UNIT_SHIFT) / 1024;
    int dbsize  = (super->size << DISK_UNIT_SHIFT) / 1024;
    fprintf(stderr, "preferred segment size = %8d K\n", segsize);
    fprintf(stderr, "maximum database size  = %8d K\n", dbsize);

    return TRUE;
}

bool valid_superblock(Disk_SB*) {
    // XXX _Need a real implementation that uses the "checksum" field.
    return TRUE;
}
