// Copyright 1995 Barbara Liskov

#include "common/th_assert.h"
#include "or/or.h"
#include "handle.h"
#include "itable.h"
#include "scache.h"

implementArray(MM_HandleList,MM_Handle*)

MM_Handle::MM_Handle(MM_Handle const& h) {
    th_fail("called MM_Handle copy constructor");
}

MM_Handle& MM_Handle::operator = (MM_Handle const& h) {
    th_fail("called MM_Handle assignment operator");
    return *this;
}

MM_Handle::~MM_Handle() {
    if (in_itable)
	mod->unref();
    else {
	if (entry)
	    entry->unpin();
    }
}

// Fast allocation stuff.  We cannot use fast_alloc.h because "MM_Handle"
// has constructors and classes with constructors cannot be placed in
// unions.

// We can use a static variable here because allocation/deallocation of
// handles is supposed to occur only when "mm->mutex" is held.
static MM_Handle* free_list = 0;

void* MM_Handle::operator new(size_t s) {
    th_assert(s == sizeof(MM_Handle), "Bad size passed to new");

    MM_Handle* result;
    if (free_list != 0) {
	result = free_list;
	free_list = free_list->next;
    }
    else {
	result = (MM_Handle*) (::operator new(s));
    }

    return result;
}

void MM_Handle::operator delete(void *x) {
    MM_Handle* h = (MM_Handle*) x;
    h->next = free_list;
    free_list = h;
}
