// Copyright 1995 Barbara Liskov

#include <stdio.h>

#include "common/th_assert.h"
#include "or/or_config.h"

#include "disk.h"
#include "handle.h"
#include "mm.h"
#include "pagetable.h"

implementArray(PageTableRep, Page*)

static Page* makePageFromSegment(OR *or, int segnum) {
  Page *p = new Page();
  Oref ref;
  int ornum = or->config->ornum;
  int index = 0;
  int slotx = 0; 
  loop {
    OREF_SET(ref,segnum,index);
    MM_Handle* h = or->mm->fetch(ref);
    if (h != 0) {
      // copy object into next free space in page
      OR_obj* x = h->obj();
#if 0
      fprintf(stderr, "Copying object %d.%d into page %d\n", OREF_SEGMENT(ref), OREF_INDEX(ref), segnum);
#endif
      // Put xref into first slot
      p->contents[slotx].xref.or = ornum;
      p->contents[slotx].xref.oref = ref;
      slotx++;
      // Put object into slots
      int numslots = OR_obj_full_size(x);
      OR_slot *curr_slot = (OR_slot*)x;
      for (int i = 0; i < numslots; i++) {
	th_assert(slotx < PAGE_SLOTS, "Overflowed page");
	p->contents[slotx] = *(curr_slot + i);
	slotx++;
      }
      or->mm->release(h);
    }
    else 
      break;
    index++;
  }
  return p;
}

Page_Table::Page_Table(OR *or, Segment_Table *segtab) {
  rep = new PageTableRep();
  // iterate over all segments; assume they are dense and start at 0
  int segnum = 0;
  loop {
    Disk_Range r;
    if (segtab->find(segnum, r)) {
#if 1
      fprintf(stderr, "Creating page from segment %d\n", segnum);
#endif
      Page *p = makePageFromSegment(or, segnum);
      rep->append(p);
      segnum++;
    }
    else
      break;
  }
}

Page* Page_Table::fetch(int pagenum) {
   if ((pagenum >= 0) && (pagenum < rep->size()))
     return rep->slot(pagenum);
   else
     return 0;
 }

