// Copyright 1995 Barbara Liskov

// \section{Reservation Information Implementation}

#include "common/device.h"
#include "common/mos.h"
#include "common/nos.h"
#include "common/orefs.h"
#include "rinfo.h"

Rinfo::Rinfo(Mos* m, Nos* n) : olist(n->count()) {
    stamp = -1;
    mos   = m;
    nos   = n;
}

// Do not provide any definition of "Rinfo::Rinfo()" and
// "Rinfo::Rinfo(Rinfo const&)" because we do not want
// rinfos being copied around and allocated indiscriminately.

Rinfo::~Rinfo() {
    delete mos;
    delete nos;
}

int Rinfo::rep_size() {
    return (mos->rep_size() +
	    nos->rep_size() +
	    sizeof(Oref) * olist.size());
}

bool Rinfo::encode(Device* dev) {
    return (mos->encode(dev) &&
	    nos->encode(dev) &&
	    dev->send_buffer(olist.as_pointer(), sizeof(Oref)*olist.size())
	    );
}

bool Rinfo::decode(Device* dev) {
    if (! (mos->decode(dev) && nos->decode(dev))) return FALSE;

    // Read orefs for the new objects
    olist.clear();
    olist._enlarge_by(nos->count());
    return (dev->recv_buffer(olist.as_pointer(),
			     sizeof(Oref) * nos->count()));
}
